function y=Phi(n,tk,K,Ts,B)
% This function calculate the sampled response of ideal band pass filter to
% a dirac at time tk
% Written by Kfir Gedalyahu and Rami Cohen

% n - samples vector
% tk - delay 
% K - modulation band
% Ts - sampling period

t=n*Ts-tk;
y=sinc(t*B).*exp(j*2*pi*B*(K+0.5)*t);
