function [tk_FRI,tk_FRI_Cadzow,xk_FRI,xk_FRI_Cadzow]=Estimate_tk_xk(c_n,K,tau,K_set,b_k,tk,xk,filter_type)
%% Init
B = length(c_n)/tau;
T = 1/B;
%% Compute DFT and calibrate using b_k
C_K = fftshift(fft(c_n));
C_K = C_K(:);
S = diag(b_k); % Filter coefficients
C_K_calibrated = S^(-1)*C_K; 
%% Estimate tk's
%a = FRI_classic(C_K,K,tau);
tk_FRI = FRI_classic(C_K_calibrated,K,tau);
disp('----------------------------------------------------------------------------------------------------------');
disp(sprintf('Annihilating Filter - Sqrt of Squared error = %0.3g', norm(tk_FRI - tk)))
%disp(sprintf('Sqrt of Squared error Using chosen samples= %0.3g', norm(tk_FRI_chosen - tk)))
% tk_FRI_Cadzow_chosen = FRI_Cadzow(ym_chosen,B,T,K,tau);
tk_FRI_Cadzow = FRI_Cadzow(C_K_calibrated,B,T,K,tau);
disp(sprintf('Cadzow FRI - Sqrt of Squared error = %0.3g', norm(tk_FRI_Cadzow - tk)))
% disp(sprintf('Cadzow - Sqrt of Squared error Using chosen samples= %0.3g', norm(tk_FRI_Cadzow_chosen - tk)))
disp('------------------------------------------');

%% Estimate amplitudes xk

[TK_FRI,M_Mat]=meshgrid(tk_FRI,K_set);
my_mat = exp(-1i*2*pi/tau*TK_FRI.*M_Mat);
xk_FRI = pinv(my_mat)*C_K_calibrated*(strcmp(filter_type,'SoS_filter')+1); 
disp(sprintf('Error in apmlitudes, xk, Using estimated tk_FRI = %0.3g', norm(xk_FRI - xk)))
[TK_FRI_CADZOW,M_Mat]=meshgrid(tk_FRI_Cadzow,K_set);
my_mat = exp(-1i*2*pi/tau*TK_FRI_CADZOW.*M_Mat);
xk_FRI_Cadzow = pinv(my_mat)*C_K_calibrated*(strcmp(filter_type,'SoS_filter')+1); 
disp(sprintf('Error in apmlitudes, xk, Using estimated tk_FRI_Cadzow = %0.3g', norm(xk_FRI_Cadzow - xk)))

% no need to multiply by tau since C_k is actually tau*(fourier series
% coeff.).


