% This is a function which returns the sum of sincs filter, given:
% tau - The window of the signal (the period in the periodic case)
% K_set - The set of indices chosen to be nonzero, of cardinality M (the
% number of Fourier coefficients which come into play
% b_k - the coefficients. Its dimensions are (M by 1).


function [SOS_filter,SOS_filter_in_frequency] = SumOfSincsFilter(t,tau,K_set,b_k,plot_flag,num_periods)
[K_SET,FILTER_TIMES] = meshgrid(K_set,t);
M = length(K_set);
b_k = b_k(:);
% SOS_filter = exp(1j*2*pi*K_SET.*FILTER_TIMES/tau)*conj(b_k)/M.*( 0.5*(abs(t(:))<=(tau/2*num_periods)) + 0.5*(abs(t(:))<tau/2*num_periods));
SOS_filter = exp(1j*2*pi*K_SET.*FILTER_TIMES/tau)*conj(b_k)/M.*( 0.5*(abs(t(:))<=(tau/2*num_periods))); 

if plot_flag
    figure('Name','Real Part of Filter in the Time Domain');
    plot(t,real(SOS_filter),'LineWidth',1.5)
    xlabel('time [units of \tau]'); ylabel('magnitude');
    ylabel('The filter g(t)');
    figure('Name','Imaginary Part of Filter in the Time Domain');
    plot(t,imag(SOS_filter),'LineWidth',1.5)
    xlabel('time [units of \tau]'); ylabel('magnitude');
    ylabel('The filter g(t)');
    
end

omegas = (-400:400)*2*pi/tau/10;
[Ks,OMEGAS] = meshgrid(K_set,omegas);
SOS_filter_in_frequency = tau/sqrt(2*pi)*sinc(OMEGAS/(2*pi/tau)-Ks)*conj(b_k);
if plot_flag
    figure('Name','Filter in Frequency Domain');
    plot(omegas,SOS_filter_in_frequency,'LineWidth',1.5);
    xlabel('Frequency [Rad/sec]'); 
    ylabel('G(\omega)');
end