% Applies annihilating filter + Cadzow algorithm
function [tk,ann_filter_coeff]=FRI_Cadzow(ym,B,T,K,tau)
% ym - dft of the samples
% B - sinc bandwidth
% K - number of diracs
% tau - period time

N=length(ym);
M=floor(N/2);

Maxiter=40;
Stop_factor=1000;
%% Cadzow
ym_est=ym;

for loop=1:Maxiter
    
    L=M;
    A=zeros(2*M-L+1,L+1);

    for i=0:2*M-L;
        A(i+1,:)=ym_est((-M+L:-1:-M)+ceil(N/2)+i);
    end;

    %  find closest rank K matrix
    [U,S,V]=svd(A,0);
    if S(K,K)/Stop_factor>S(K+1,K+1)
        break;
    end;
    S(sub2indfast(size(S),K+1:length(S),K+1:length(S)))=0;
    A=U*S*V';

    ym_est=zeros(size(ym));

    % find closest toeplitz matrix
    for i=0:L
        if i==0
            ym_est(ceil(N/2)+i)=sum(A(sub2indfast(size(A),1:L+1,1:L+1)))/(L+1);
        else

              dm=0.5/(L+1-i)*sum(A(sub2indfast(size(A),(1+i):L+1,1:(L+1-i))))+0.5/(L+1-i)*conj(sum(A(sub2indfast(size(A),1:(L+1-i),1+i:L+1)))); 
              ym_est(ceil(N/2)+i)=dm;
              ym_est(ceil(N/2)-i)=conj(dm);

        end
    end

end

%% total least squares 

L=K;

A=zeros(2*M-L+1,L+1);

for i=0:2*M-L;
    A(i+1,:)=ym_est((-M+L:-1:-M)+ceil(N/2)+i);
end;

[U,S,V]=svd(A,0);    

ann_filter_coeff=V(:,K+1);

tk=sort(mod(-angle(roots(ann_filter_coeff))/(2*pi)*tau,tau));


end

function ind=sub2indfast(sizeA,i,j)
ind=(j-1)*sizeA(1)+i;

end

