% Implements the annihilating filter
function [tk,ann_filter_coeff]=FRI_classic(ym,K,tau)
% ym - dft of the samples
% K - number of diracs
% tau - period time

N=length(ym);
M=floor(N/2);

%% total least squares 

L=K; % filter length

r = ym( (-M+L:-1:-M) + floor(N/2)+1 );
c = ym( (-M+L:M) + floor(N/2) + 1 );
my_A = toeplitz(c,r);

% A=zeros(2*M-L+1,L+1);
% for i=0:2*M-L;
%     A(i+1,:)=ym((-M+L:-1:-M)+ceil(N/2)+i);
% end;
% isequal(my_A,A)

[U,S,V]=svd(my_A,0);    

ann_filter_coeff=V(:,K+1);

tk=sort(mod(-angle(roots(ann_filter_coeff))/(2*pi)*tau,tau));
%% Another way to look at the modulus operation:
% temp = -angle(roots(ann_filter_coeff))/(2*pi)*tau;
% tk=sort(temp + tau*(temp<0));