function PlotLabel(label, xvec, yvec, index, options, FontSize)

if(nargin<6)
    FontSize = 7;
end

dy=1.2;

if(nargin<5 | strcmp(options,'left'))
    xline = mean(xvec(index-1:index));
    yline = mean(yvec(index-1:index));
    xlabel = xvec(index+1);
    ylabel = yline/dy;
    text(xlabel,ylabel,label,'FontSize',FontSize,'Color',[0 0 0]);
    line([xlabel-0.3 xline],[ylabel yline],'Color',[0 0 0]);
elseif(strcmp(options,'left,long'))
    xline = mean(xvec(index-1:index));
    yline = mean(yvec(index-1:index));
    xlabel = xvec(index+2);
    ylabel = yline/(2*dy);
    text(xlabel,ylabel,label,'FontSize',FontSize,'Color',[0 0 0]);
    line([xlabel-0.3 xline],[ylabel yline],'Color',[0 0 0]);
elseif(strcmp(options,'right'))
    xline = mean(xvec(index:index+1));
    yline = mean(yvec(index:index+1));
    xlabel = xvec(index-1);
    ylabel = yline*dy;
    text(xlabel,ylabel,label,'FontSize',FontSize,'Color',[0 0 0],'HorizontalAlignment','right');
    line([xlabel+0.3 xline],[ylabel yline],'Color',[0 0 0],'LineWidth',0.5);
elseif(strcmp(options,'right,long'))
    xline = mean(xvec(index:index+1));
    yline = mean(yvec(index:index+1));
    xlabel = xvec(index-2);
    ylabel = yline*2*dy;
    text(xlabel,ylabel,label,'FontSize',FontSize,'Color',[0 0 0],'HorizontalAlignment','right');
    line([xlabel+0.3 xline],[ylabel yline],'Color',[0 0 0],'LineWidth',0.5);
elseif(strcmp(options,'top'))
    xline = mean(xvec(index-1:index));
    yline = mean(yvec(index-1:index));
    xlabel = xvec(index+1);
    ylabel = yline*dy;
    text(xlabel,ylabel,label,'FontSize',FontSize,'Color',[0 0 0],'HorizontalAlignment','left');
    line([xlabel-0.1 xline],[ylabel yline],'Color',[0 0 0]);
end;
