function [tk,ann_filter_coeff]=annihilating_filter(samples,K)
% samples - samples of the power-sum series
% K - number of diracs

N=length(samples);
M=floor(N/2);

%% total least squares 

L=K; % filter length

r = samples( (-M+L:-1:-M) + floor(N/2)+1 );
c = samples( (-M+L:M) + floor(N/2) + 1 );
my_A = toeplitz(c,r);

% A=zeros(2*M-L+1,L+1);
% for i=0:2*M-L;
%     A(i+1,:)=samples((-M+L:-1:-M)+ceil(N/2)+i);
% end;
% isequal(my_A,A)

[U,S,V]=svd(my_A,0);    

ann_filter_coeff=V(:,K+1);

tk=sort(roots(ann_filter_coeff));
%% Another way to look at the modulus operation:
% temp = -angle(roots(ann_filter_coeff))/(2*pi)*tau;
% tk=sort(temp + tau*(temp<0));