#!/usr/bin/python
# -*- coding: iso-8859-1 -*-
#
# Copyright (C) 2010 Orr Srour
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>
# 


import Tkinter
import sys
import threading

head_text=u"""
    fia_analysis performs the following two main steps:
    
        1) Metabolic pathway analysis.
        
            Here FIA transforms the text file representing the metabolic network into
            mathematical matrices required later for the MFA optimization process.            
            
        2) Metabolic fluxes evaluation.

            Here FIA tries to find the fluxes that best suit the given metabolic system.

    fia_analysis supports two types of input file formats: FIA and 13CFlux FTBL.
    The two are very much alike, except for the fact that the FIA format supports only declaration of
    uni-directional fluxes, and does not contain the FLUXES, EQUALITIES and INEQUALITIES sections.
    For bi-directional fluxes, FIA simply defines two seperated fluxes.
    When analyzing 13CFlux FTBL files, fia_analysis looks for C=0 constraints in the FLUXES XCH section
    in order to determine directionality of fluxes.
    """

class fia_gui(Tkinter.Tk):
    def __init__(self,parent):
        Tkinter.Tk.__init__(self,parent)
        self.parent = parent
        self.initialize()

    def initialize(self):
        self.grid()

##        self.header = Tkinter.Label(self, textvaraible="FIA - Fluomxer Iterative Algorithm")
##        self.header.grid(column=0,row=0,sticky='EW')
##        
##        self.entryVariable = Tkinter.StringVar()
##        self.entry = Tkinter.Entry(self,textvariable=self.entryVariable)
##        self.entry.grid(column=0,row=0,sticky='EW')
##        self.entry.bind("<Return>", self.OnPressEnter)
##        self.entryVariable.set(u"Enter text here.")

##        button = Tkinter.Button(self,text=u"Click me !",
##                                command=self.OnButtonClick)
##        button.grid(column=1,row=0)

        #self.labelVariable = Tkinter.StringVar()

##        label = Tkinter.Label(self,textvariable=self.labelVariable,
##                              anchor="c",fg="white",bg="blue")

        # Add the FIA title
        label = Tkinter.Label(self,text="FIA - Fluxomers Iterative Algorithm - Ver 1.00",
                              anchor="c",fg="white",bg="blue")
        label.pack()
        label.grid(column=0,row=0,sticky='EW', columnspan =100)

        # Add the heading text:
        headtext = Tkinter.Label(self,text=head_text, anchor="w", justify="left")
        headtext.pack()
        headtext.grid(column=0,row=1,stick='EW', columnspan=100)
    
        # Add the file textbox and browser button
        inpfile_row = 2
        inpfile = Tkinter.Label(self,text="Input file:", anchor="w")
        inpfile.grid(column=0,row=inpfile_row, sticky='W')
        self.inpFileVar = Tkinter.StringVar()
        fileEntry = Tkinter.Entry(self, textvariable=self.inpFileVar)
        fileEntry.grid(column=1,row=inpfile_row,sticky='EW')
        fileEntry.bind("<Return>", self.OnInpPressEnter)
        fileEntry.bind("<Return>", self.OnInpPressEnter)
        InpBrowseButton = Tkinter.Button(self,text = "Browse...",command=self.OnInpBrowseButtonClick)
        InpBrowseButton.grid(column=2,row=inpfile_row)
        #self.labelVariable.set(u"FIA - Fluxomer Iterative Algorithm")

        # Add the input file type radio button
        filetype_row = inpfile_row + 1
        self.filetype = Tkinter.StringVar()
        self.filetype.set("fia") # initialize
##        b = Tkinter.Radiobutton(self, text="Hello", variable="a", value="a")
##        b.grid(row=3,column=1)
            
        b = Tkinter.Radiobutton(self, text="FIA file format",
                                variable=self.filetype, value="fia", justify="left", compound="right")
        b.grid(column=0,row=filetype_row,sticky='W')
        #b.pack()
        
        b = Tkinter.Radiobutton(self, text="13CFlux FTBL file format",
                                variable=self.filetype, value="ftbl", justify="left", compound="left")  
        b.grid(column=0,row=filetype_row+1,sticky='W')
        
        # Add the file outputbox and browser button
        outfile_row = filetype_row + 2
        outfile = Tkinter.Label(self,text="Results file:", anchor="w")
        outfile.grid(column=0,row=outfile_row, sticky='W')
        self.outFileVar = Tkinter.StringVar()
        outfileEntry = Tkinter.Entry(self, textvariable=self.outFileVar)
        outfileEntry.grid(column=1,row=outfile_row,sticky='EW')        
        OutBrowseButton = Tkinter.Button(self,text = "Browse...",command=self.OnOutBrowseButtonClick)
        OutBrowseButton.grid(column=2,row=outfile_row)        


        # Add the flux upper constraint
        maxvalrow = outfile_row + 1
        maxval = Tkinter.Label(self,text="Flux upper bound value (0=auto):", anchor="w")
        maxval.grid(column=0,row=maxvalrow, sticky='W')
        self.maxval = Tkinter.StringVar()
        self.maxval.set(0) # Default max flux value
        maxvalentry = Tkinter.Entry(self, textvariable=self.maxval)
        maxvalentry.grid(column=1,row=maxvalrow,sticky='W')
##        maxvalnote = Tkinter.Label(self,text="(0 = choose automatically max(input_fluxes) * 5)", anchor="w")
##        maxvalnote.grid(column=2,row=maxvalrow, sticky='W')
        
        # Virtual Flux Strength
        virtfluxrow = maxvalrow + 1
        virtval = Tkinter.Label(self,text="Virtual flux value:", anchor="w")
        virtval.grid(column=0,row=virtfluxrow, sticky='W')
        self.virtval = Tkinter.StringVar()
        self.virtval.set(1e-7) # Default max flux value
        virtvalentry = Tkinter.Entry(self, textvariable=self.virtval)
        virtvalentry.grid(column=1,row=virtfluxrow,sticky='W')
        #maxvalentry.bind("<Return>", self.OnInpPressEnter)
        #maxvalentry.bind("<Return>", self.OnInpPressEnter)
        
##        maxval = Tkinter.Entry(self, textvariable=self.inpFileVar)
##        maxval.grid(column=1,row=inpfile_row,sticky='EW')
##        maxval.bind("<Return>", self.OnInpPressEnter)
##        maxval.bind("<Return>", self.OnInpPressEnter)
##        

        # Add the output textbox with scrollbar
        outbox_row = virtfluxrow + 1
        self.scrollbar = Tkinter.Scrollbar(self)
        
##        self.scrollbar.pack(side='right', fill='y')        
##        self.scrollbar.pack()
        
        self.outbox = Tkinter.Text(self,wrap='word',yscrollcommand=self.scrollbar.set)
        self.scrollbar.config(command=self.outbox.yview)
##        self.outbox.pack(side='left',fill='y')
        
        self.outbox.grid(column=0,row=outbox_row,sticky='EW', columnspan=3)
        self.scrollbar.grid(column=4,row=outbox_row,sticky='WNS')
        
        # Add the "Go" button
        go_button_row = outbox_row + 1
        self.go_button = Tkinter.Button(self)
        self.go_button["text"] = "Run analysis..."
        self.go_button["command"] = self.run_analysis
        self.go_button.pack()
        self.go_button.grid(row=go_button_row,sticky='ESN', columnspan=100)
        
        #self.grid_columnconfigure(0,weight=1)
        self.grid_columnconfigure(1,weight=1)
##        self.resizable(True,False)
        self.update()
        self.geometry(self.geometry())       
##        self.entry.focus_set()
##        self.entry.selection_range(0, Tkinter.END)

    def OnInpBrowseButtonClick(self):
        import tkFileDialog
        lfd = tkFileDialog.askopenfilename()
        self.inpFileVar.set(lfd)        
        if lfd[-3:].lower()=='fia':
            self.filetype.set("fia")            
        elif lfd[-4:].lower()=='ftbl':
            self.filetype.set("ftbl")            
        self.outFileVar.set(lfd+".out")
        #self.labelVariable.set( self.entryVariable.get()+" (You clicked the button)" )
        #self.entry.focus_set()
        #self.entry.selection_range(0, Tkinter.END)

    def OnOutBrowseButtonClick(self):
        import tkFileDialog
        lfd = tkFileDialog.asksaveasfilename()
        self.outFileVar.set(lfd)
        #self.labelVariable.set( self.entryVariable.get()+" (You clicked the button)" )
        #self.entry.focus_set()
        #self.entry.selection_range(0, Tkinter.END)

    #def OnInpPressEnter(self,event):
        
    def OnInpPressEnter(self,event):
##        self.labelVariable.set( self.entryVariable.get()+" (You pressed ENTER)" )
##        self.entry.focus_set()
##        self.entry.selection_range(0, Tkinter.END)
        self.outFileVar.set(self.inpFileVar.get()+".out")

    def write(self,txt):
        self.outbox.insert(Tkinter.END,txt)
        self.outbox.yview(1000000)
        
    def flush(self):
##        self.outbox.
        self.outbox.yview(1000000)
        self.update_idletasks()
        
    def run_analysis(self):
        sys.stdout = self
       
        import os.path
        import tkMessageBox
        
        if not os.path.isfile(self.inpFileVar.get()):
            tkMessageBox.showerror('Input file missing','Please select a valid input file')
            return
        elif os.path.isfile(self.outFileVar.get()):
            if not tkMessageBox.askyesno('Output file already exists','The given output file already exists.\nDo you want to overwrite it?'):
                return                            
##              print ['--'+self.filetype.get(),self.inpFileVar.get(),'-o',self.outFileVar.get()]
        FIT = FiaAnalysisThread()    
        FIT.set_p(['--'+self.filetype.get(),self.inpFileVar.get(),'-o',self.outFileVar.get(),'-b',self.maxval.get(),'-v',self.virtval.get()])
        FIT.start()

        
class FiaAnalysisThread( threading.Thread ):
#    def __init__( self, param):
#        self.p = param
    def set_p( self, p ):
        self.p = p
    def run( self ):
        import fia_analysis
        fia_analysis.main( self.p )

if __name__ == "__main__":
    app = fia_gui(None)
    app.title('FIA - Fluxomers Iterative Algorithm')
    app.mainloop()
