function res_im=FISTA_based_solver(Y,lambda1,lambda2,numIter,reference_image,weighting_matrix,enforce_data_consistency)
W=Wavelet;
L=10;
im_cs=abs(ifft2c(Y));
X=W*im_cs;
ref_in_wavelet=W*reference_image;
Z=X;
t_k=1;
mu1=(1e-3)*(1/((lambda1+lambda2)/2));
 h = waitbar(0,'Please wait...','Name','Minimization solver');
for iter=1:numIter
     waitbar(iter/numIter,h,['Iteration #',num2str(iter),' of ',num2str(numIter)]);
    X_old=X;
    grad_f=W*(ifft2c((Y~=0).*fft2c(W'*Z)-Y));
    grad_g1=(1/mu1)*(X-SoftThresh(X,mu1*lambda1));
    temp_val=weighting_matrix.*(W'*(X-ref_in_wavelet));
    grad_g2=(1/mu1)*(weighting_matrix.*(W*(temp_val-SoftThresh(temp_val,mu1*lambda2))));
    
    X=Z-(1/L)*(grad_f+grad_g1+grad_g2);
    if enforce_data_consistency
        temp_Y=fft2c(W'*(X));
        temp_Y(Y~=0)=Y(Y~=0);
        X=W*ifft2c(temp_Y);
    end
    
    t_k_1=(1+sqrt(1+4*t_k^2))/2;
    Z=X+((t_k-1)/t_k_1)*(X-X_old);
    t_k=t_k_1;
end
res_im=abs(W'*X);
close(h);