%% This script shows an example of reference based MRI for utilizing similarity between T2 and FLAIR contrasts

%% Load fully sampled images
load data % im1: T2 image. im2: FLAIR image

%% Generate variable density random sampling pattern
pctg=0.15; %percentage of k-space sampling
radius=0.03; %radius of inner k-space to acquire in full
p=4; %polynomial order for pdf
sucss_flag=0;
while ~sucss_flag
    try
        [pdf,val] = genPDF(size(im1),p,pctg,2,radius,0);
    catch
        continue;
    end
    sucss_flag=1;
end
s = RandStream('mt19937ar','Seed',1);
sampling_mask=pdf>rand(s,size(im1));

%% Undersample FLAIR data in k-space domain
size_im=size(im1,1);
im2_k_space=fft2c(im2)./pdf;
Y=(sampling_mask.*im2_k_space);

%% Weight similarity in reconstruction - do not enforce sparsity in regions with high t2 value
weighting_matrix=ones(size_im);
weighting_matrix(abs(im1)>0.4)=0.5;

%% call FISTA to solve minimization problem: ||Y-FW'X||_2+lambda1||X||_1+lamda2||weighting_matrix.*(X-X_ref)||_1
lambda1=0.025; %sparsity in wavelet
lambda2=0.03; %similarity to reference
res_im=FISTA_based_solver(Y,lambda1,lambda2,20,im1,weighting_matrix,1);

%% For comparison: use FISTA to solve ||Y-FW'X||_2+lambda1||X||_1 (standard wavelet based compressed sensing)
lambda2=0; %similarity to reference
res_im_cs=FISTA_based_solver(Y,lambda1,lambda2,20,im1,weighting_matrix,1);

%% Show results
figure; imagesc(flipud(im1'),[0 0.75]); colormap(gray); title('Original T2 image');
figure; imagesc(flipud(im2'),[0 0.75]); colormap(gray); title('Original FLAIR image');
figure; imagesc(flipud(res_im_cs'),[0 0.75]); colormap(gray); title('Reconstructed FLAIR image from 15% of data with wavelet based CS');
figure; imagesc(flipud(res_im'),[0 0.75]); colormap(gray); title('Reconstructed FLAIR image from 15% of data with reference based MRI');
