function sampling_matrix=generate_samples(f_R,f_VD,gamma,percentage_to_sample)
pdf=gamma*f_R+(1-gamma)*f_VD;
s = RandStream('mt19937ar','Seed',1);
r_mat=rand(s,size(f_R));
pdf2=(r_mat.*pdf);
pdf3=pdf2(:);
[~, b]=sort(pdf3);
b=flipud(b);
threshold_for_sampling=pdf3(b(round(percentage_to_sample*length(b))));
sampling_matrix=zeros(size(f_R));
sampling_matrix(pdf2>=threshold_for_sampling)=1;
