function [res_im_cs, res_no_cs]=FISTA_based_solver(k_space_thin_slice1,k_space_thin_slice2,k_space_thick_slice,lambda1,lambda2,lambda3,A,numIter)
W=Wavelet;
L=10;
X11=ifft2c(k_space_thin_slice1);
X2=ifft2c(k_space_thin_slice2);
X3=ifft2c(k_space_thick_slice);
X1=X11/2-X2/2+X3;
X2=X2/2-X11/2+X3;
X=[X1; X2; X3;];
res_no_cs=abs([X1; X2]);
block_size=size(k_space_thin_slice1,1);
Z=X;
t_k=1;
mu1=(1e-3)*(1/((lambda1+lambda2+lambda3)/3));
B=[eye(block_size) -eye(block_size) zeros(block_size)];
C=[eye(block_size)./2 eye(block_size)./2 -eye(block_size)];
D=[eye(block_size) zeros(block_size) zeros(block_size)];
E=[zeros(block_size) eye(block_size) zeros(block_size)];
Y=[k_space_thin_slice1;k_space_thin_slice2;k_space_thick_slice];
 h = waitbar(0,'Please wait...','Name','Minimization solver');
    for iter=1:numIter
        waitbar(iter/numIter,h,['Iteration #',num2str(iter),' of ',num2str(numIter)]);
        X_old=X;
        grad_f=A.*(fft2c_on_blocks((Y~=0).*fft2c_on_blocks(Z,block_size,0)-Y,block_size,1));
        
        temp_val1=B*X;   
        grad_g1=(1/mu1)*B'*(temp_val1-SoftThresh(temp_val1,mu1*lambda1));
        
        temp_val2=C*X;
        grad_g2=(1/mu1)*C'*(temp_val2-SoftThresh(temp_val2,mu1*lambda2));
        
        temp_val3=W*(D*X);
        grad_g3=(1/mu1)*D'*(W'*(temp_val3-SoftThresh(temp_val3,mu1*lambda3)));
        
        temp_val4=W*(E*X);
        grad_g4=(1/mu1)*E'*(W'*(temp_val4-SoftThresh(temp_val4,mu1*lambda3)));
              
        
        X=Z-(1/L)*(grad_f+grad_g1+grad_g2+grad_g3+grad_g4);   
        t_k_1=(1+sqrt(1+4*t_k^2))/2;
        Z=X+((t_k-1)/t_k_1)*(X-X_old);
        t_k=t_k_1;
    end
   res_im_cs=abs(X(1:2*block_size,1:block_size));
   close(h);