function [f,g]=eval_fun_stml(p,S,A,b,sigma_w,sigma_e,x)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This function evaluates the objective function and gradient of the STML
% objective function: (A*x-b)'*Sigma^{-1}*(A*x-b)+log(det(Sigma))
%
% Based on the paper
% Amir Beck and Yonina Eldar, "Structured Total Maximum Likelihood:An Alternative to Structured Total Least-Squares"
% -----------------------------------------------------------------------
% Copyright (2009): Amir Beck and Yonina Eldar
% 
% FISTA is distributed under the terms of 
% the GNU General Public License 2.0.
% 
% Permission to use, copy, modify, and distribute this software for
% any purpose without fee is hereby granted, provided that this entire
% notice is included in all copies of any software which is or includes
% a copy or modification of this software and in all copies of the
% supporting documentation for such software.
% This software is being provided "as is", without any express or
% implied warranty.  In particular, the authors do not make any
% representation or warranty of any kind concerning the merchantability
% of this software or its fitness for any particular purpose."
%-------------------------------------------------------------
% INPUT
% 
% p ................................. number of structure components
% S ................................. three dimensional array containing
%                                       all structure matrices.  S is of
%                                       dimension mxnxp where m,n are the
%                                       row and column dimension of the
%                                       matrix A_o.
% A ...............................  an  mxn matrix.
% b ...............................  an  m dimensional vector
% sigma_w ................  standard deviation of the righthand side vector
% sigma_e ................  standard deviation of the structure components. 
%
% OUTPUT
% 
% f ...............................  objective function value:
%                                      (A*x-b)'*Sigma^{-1}*(A*x-b)+log(det(
%                                      Sigma))
% g ...............................   gradient of objective function
[m,n]=size(S(:,:,1));
D=zeros(m,1);

for i=1:p
    D=[D,S(:,:,i)*x];
end

M=sigma_w^2*eye(m)+sigma_e^2*D*D';
M_inv=inv(M);
f=(A*x-b)'*M_inv*(A*x-b)+log(det(M));
g=A'*(M_inv*(A*x-b));
for i=1:p
    g=g+sigma_e^2*S(:,:,i)'*(M_inv*(S(:,:,i)*x));
end
for i=1:p
    v=S(:,:,i)'*(M_inv*(A*x-b));
    g=g-sigma_e^2*(x'*v)*v;
end
g=2*g;


