 function [val,x]=gfun_sol(alpha,sigma_w,sigma_e,A,b,DDT,CTC);
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Computes the  function 
% G(alpha)=min  (Ax-b)'*Sigma*(Ax-b)+log det Sigma   s.t. x'*CTC*x=alpha
% where Sigma = sigma_w^2*I+sigma_e^2 *alpha* DDT
% This function also outputs the minimizer x
%
% Based on the paper
% Amir Beck and Yonina Eldar, "Structured Total Maximum Likelihood:An Alternative to Structured Total Least-Squares"
% -----------------------------------------------------------------------
% Copyright (2009): Amir Beck and Yonina Eldar
% 
% FISTA is distributed under the terms of 
% the GNU General Public License 2.0.
% 
% Permission to use, copy, modify, and distribute this software for
% any purpose without fee is hereby granted, provided that this entire
% notice is included in all copies of any software which is or includes
% a copy or modification of this software and in all copies of the
% supporting documentation for such software.
% This software is being provided "as is", without any express or
% implied warranty.  In particular, the authors do not make any
% representation or warranty of any kind concerning the merchantability
% of this software or its fitness for any particular purpose."
%-------------------------------------------------------------
% INPUT
%
% alpha ................................. nonnegative scalar
% sigma_e ............................ positive scalar (standard deviation
%                                                 of the structure components)
% sigma_w ............................ positive scalar (standard deviation
%                                                 of the righthand side vector
% A ............................................ An mxn matrix 
% b ............................................ An m-length column vector
% DDT ....................................... mxm positive semidefinite
%                                                  matrix. Should be equal
%                                                  to D*D'
% CTC ...................................... nxn positive semidefinite
%                                                  matrix. Should be equal to C'*C
% 
% OUTPUT
% 
% val  ...................................... the value G(alpha)  
% x ............................................  the minimizer x

                  
[m,n]=size(A);
Dinv=inv(sigma_w^2*eye(m)+alpha*sigma_e^2*DDT);
B=A'*Dinv*A;
c=A'*Dinv*b;  
d=b'*Dinv*b;
G=CTC; 
G=(G+G')/2;
B=(B+B')/2;

 [x,eta]=gtrs(B,c,G,alpha);
 val=(A*x-b)'*(Dinv*(A*x-b))-log(det(Dinv));
 