function [x,eta]=gtrs(B,c,G,beta)
%solves the trust region subproblem min x'*B*x-2c'*x s.t. x'*G*x = beta
%
% Based on the paper
% Amir Beck and Yonina Eldar, "Structured Total Maximum Likelihood:An Alternative to Structured Total Least-Squares"
% -----------------------------------------------------------------------
% Copyright (2009): Amir Beck and Yonina Eldar
% 
% FISTA is distributed under the terms of 
% the GNU General Public License 2.0.
% 
% Permission to use, copy, modify, and distribute this software for
% any purpose without fee is hereby granted, provided that this entire
% notice is included in all copies of any software which is or includes
% a copy or modification of this software and in all copies of the
% supporting documentation for such software.
% This software is being provided "as is", without any express or
% implied warranty.  In particular, the authors do not make any
% representation or warranty of any kind concerning the merchantability
% of this software or its fitness for any particular purpose."
%-------------------------------------------------------------
%
% INPUT
%
% B.............................. nxn symmetric matrix
% c ............................. n-length column vector
% G ............................. nxn positive definite matrix
% beta ..................... positive scalar
%
%OUTPUT
%
%x .............................. optimal solution of min x'*B*x-2c'*x s.t.x'*G*x = beta
%
% eta ........................ the optimal value of the above problem
clear opts
opts.tol=1e-6;
opts.disp=0;
G=(G+G')/2;
B=(B+B')/2;

d=min(eig(B,G));

epsilon1=1e-4;
epsilon2=1e-10;

eta=d-epsilon1;
y=zeros(length(B),1);

while (abs(y'*G*y-beta)>epsilon2)
    R=chol(B-eta*G);
    y=R\(R'\c);
    z=R'\(G*y);
    phi=y'*G*y;
    phid=2*z'*z;
    eta=eta+2*(phi-phi^(1.5)/sqrt(beta))/phid;
end
x=y;
