function [x,val]=stml_dec(A,b,D,C,sigma_w,sigma_e)
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Computes the  STML estimate corresponding to the linear model
% (A+DEC)x=b+w where E and w are unknown perturbation matrix and vector.
% The function uses the MATLAB function fminbnd employed on the
% one-dimensional formulation of the corresponding optimization problem
% 
% Based on the paper
% Amir Beck and Yonina Eldar, "Structured Total Maximum Likelihood:An Alternative to Structured Total Least-Squares"
% -----------------------------------------------------------------------
% Copyright (2009): Amir Beck and Yonina Eldar
% 
% FISTA is distributed under the terms of 
% the GNU General Public License 2.0.
% 
% Permission to use, copy, modify, and distribute this software for
% any purpose without fee is hereby granted, provided that this entire
% notice is included in all copies of any software which is or includes
% a copy or modification of this software and in all copies of the
% supporting documentation for such software.
% This software is being provided "as is", without any express or
% implied warranty.  In particular, the authors do not make any
% representation or warranty of any kind concerning the merchantability
% of this software or its fitness for any particular purpose."
%-------------------------------------------------------------
%
% INPUT
%
% sigma_w ............................ positive scalar (standard deviation
%                                                 of the righthand side
%                                                 vector w)
% sigma_e ............................ positive scalar (standard deviation
%                                                 of the components of E)
% A ............................................ An mxn matrix 
% b ............................................ An m-length column vector
% D ............................................ mxp matrix                                                  
% C ............................................ qxn matrix
% 
% OUTPUT
% 
% x ............................................  the MSTLS estimate which
%                                                   is the solution to  min (Ax-b)'*(Sigma)\(A*x-b)+log(det(Sigma))
%                                                    where Sigma=
%                                                    sigma_w^2*I+sigma_e^2*alpha* D*D'
% val .......................................  objective value of the
%                                                   obtained solution

[ma,na]=size(A);
[mb,nb]=size(b);
[md,nd]=size(D);
[mc,nc]=size(C);
if (ma~=mb)
    error('Number of rows in A not equal to length of b');
end
if (md~=ma)
    error('Number of columns in D not equal to the number of rows in A');
end
if (na~=nc)
    error('Number of columns in A not equal to the number of rows in C');
end
    
CTC=C'*C;
DDT=D*D';
f=@(alpha)gfun(alpha,sigma_w,sigma_e,A,b,DDT,CTC);
alpha=fminbnd(f,0,100,optimset('Display','iter','TolX',1e-6));
[val,x]=gfun_sol(alpha,sigma_w,sigma_e,A,b,DDT,CTC);
