function [x,val]=mstls_dec(A,b,D,C,sigma_w,sigma_e)
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Computes the  MSTLS estimate corresponding to the linear model
% (A+DEC)x=b+w where E and w are unknown perturbation matrix and vector.
% The function uses the MATLAB function fminbnd employed on the
% one-dimensional formulation of the corresponding optimization problem
% 
%
% INPUT
%
% sigma_w ............................ positive scalar (standard deviation
%                                                 of the righthand side
%                                                 vector w)
% sigma_e ............................ positive scalar (standard deviation
%                                                 of the components of E)
% A ............................................ An mxn matrix 
% b ............................................ An m-length column vector
% D ............................................ mxp matrix                                                  
% C ............................................ qxn matrix
% 
% OUTPUT
% 
% x ............................................  the MSTLS estimate which
%                                                   is the solution to  min (Ax-b)'*(Sigma)\(A*x-b)+log(det(Sigma))
%                                                    where Sigma=
%                                                    sigma_w^2*I+sigma_e^2*alpha* D*D'
% val .......................................  objective value of the
%                                                   obtained solution

[ma,na]=size(A);
[mb,nb]=size(b);
[md,nd]=size(D);
[mc,nc]=size(C);
if (ma~=mb)
    error('Number of rows in A not equal to length of b');
end
if (md~=ma)
    error('Number of columns in D not equal to the number of rows in A');
end
if (na~=nc)
    error('Number of columns in A not equal to the number of rows in C');
end
    
CTC=C'*C;
DDT=D*D';
f=@(alpha)gfun(alpha,sigma_e,sigma_w,A,b,DDT,CTC);
alpha=fminbnd(f,0,100,optimset('Display','iter','TolX',1e-6));
[val,x]=gfun_sol(alpha,sigma_e,sigma_w,A,b,DDT,CTC);
