function [x_stls,fval,exit_flag]=stls(p,S,A_o,b_o,sigma_w,sigma_e,x)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This function seeks a solution to  structued total least squares
% problem. It uses the MATLAB function 'fminunc' with a quasi-Newton method
% setting
%
% Based on the paper
% Amir Beck and Yonina Eldar, "Structured Total Maximum Likelihood:An Alternative to Structured Total Least-Squares"
% -----------------------------------------------------------------------
% Copyright (2009): Amir Beck and Yonina Eldar
% 
% FISTA is distributed under the terms of 
% the GNU General Public License 2.0.
% 
% Permission to use, copy, modify, and distribute this software for
% any purpose without fee is hereby granted, provided that this entire
% notice is included in all copies of any software which is or includes
% a copy or modification of this software and in all copies of the
% supporting documentation for such software.
% This software is being provided "as is", without any express or
% implied warranty.  In particular, the authors do not make any
% representation or warranty of any kind concerning the merchantability
% of this software or its fitness for any particular purpose."
%-------------------------------------------------------------
% INPUT
%
% p ................................. number of structure components
% S ................................. three dimensional array containing
%                                       all structure matrices.  S is of
%                                       dimension mxnxp where m,n are the
%                                       row and column dimension of the
%                                       matrix A_o.
% A_o ...........................  an observed mxn matrix.
% b_o ...........................  an observed m dimensional vector
% sigma_w ................  stndard deviation of the righthand side vector
% sigma_e.................  standard deviation of the structure components. 
%
% OUTPUT
% 
% x_stls ..................  the solution of the STLS problem consisting
%                                      of minimizing  (A_o x-b_o)'*(Sigma)\(A_o*x-b_o)
% fval .......................   The objective function value at the
%                                       (hopefully global) optimum

[m,n]=size(A_o);

% setting the  parameters of fminunc. The algorithm will use a quasi-Newton
% method with a bfgs rule for updating the approximated Hessian.
options = optimset('GradObj','on','LargeScale','off','HessUpdate','bfgs','TolFun',1e-7,'TolX',1e-7);

% the initial guess is set to the least squares solution
x0=A_o\b_o;
[x_stls,fval,exit_flag]=fminunc(@(x)eval_fun_stls(p,S,A_o,b_o,sigma_w,sigma_e,x),x0,options);
