function x=mstls_circulant(a_o,b_o,sigma_w,sigma_e)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute the MSTLS solution for the linear system A_o x =b where A_o is a
% circulant matrix
% Based on the paper
% Amir Beck and Yonina Eldar, "Structured Total Maximum Likelihood:An Alternative to Structured Total Least-Squares"
% -----------------------------------------------------------------------
% Copyright (2009): Amir Beck and Yonina Eldar
% 
% FISTA is distributed under the terms of 
% the GNU General Public License 2.0.
% 
% Permission to use, copy, modify, and distribute this software for
% any purpose without fee is hereby granted, provided that this entire
% notice is included in all copies of any software which is or includes
% a copy or modification of this software and in all copies of the
% supporting documentation for such software.
% This software is being provided "as is", without any express or
% implied warranty.  In particular, the authors do not make any
% representation or warranty of any kind concerning the merchantability
% of this software or its fitness for any particular purpose."
%-------------------------------------------------------------
% INPUT
%
% a_o ................................. the first row of a circulant matrix. 
% b_o ................................. a column vector of the same length
%                                            of a_o
% sigma_w ......................  standard deviation of the righthand side vector
% sigma_e ......................  standard deviation of the structure components.
%
% OUTPUT
% 
% x.......................................  The (global) solution of the
%                                             MSTLS problem  corresponding
%                                             to the linear system A_o x =
%                                             b_o

n=length(a_o);
a_o=reshape(a_o,1,n);

% computing the eigenvalues of the circulant matrix whose first row is a
ac=fliplr(a_o);ac=[ac(n),ac(1:n-1)];
alpha=fft(ac');

% setting the parameters for the 1D solver
b=1/sqrt(n)*fft(b_o);
c=n*sigma_e^2;
d=sigma_w^2;

% computing the transform  of the solution using the 1D solver
x_tilde=solve_1d(alpha,b,c,d,1e-8);

x=sqrt(n)*ifft(x_tilde);
