%% Initialize:
addpath('Bloch\');
N=128;                                                               %The image size is NxN
L = 500;                                                             %The sequence length
k_space_undersampling_ratio=0.15;             %undersampling ratio in k-space

load input_to_fisp_experiment                        %load the quantitative maps
[RFpulses, TR]=generate_RF_TR(L);            %Load slowly changing RF and TR values
RFpulses = RFpulses*1i;                                %to avoid complex values of X and D
TE = 10;%2

%% build dictionary using MRF FISP sequence, omit entries where T2>T1
if exist('D.mat')~=0                                                                                                         % you can save X, D, and LUT to D.mat to save time
    load D.mat;
else
    disp('Building the dictionary...');
    [FISP_dictionary,LUT] = build_dictionary_fisp(L,RFpulses,TR,TE);                     %build the MRF FISP dictionary and its matching look up table
    D = single(FISP_dictionary);
    clear FISP_dictionary;
    LUT = LUT*1000;                                                                                                        %change units
    disp('The dictionary is ready, building the temporal images...');
    X = build_fully_sampled_contrasts(RFpulses ,TR ,TE, T1_128,T2_128,PD_128);  %build the fully sampled temporal contrasts
    disp('The images are ready');
end

%% undersample the data in Fourier domain 
X = reshape(X,N,N*L);
sampling_matrix = genrate_binary_sampling_map(N,k_space_undersampling_ratio,L); %generates binary sampling masks
Y_full = fft_mats(X,1);
kSpaceNoise =  reshape([1 1i]*0.5*randn(2,L*N^2),N,L*N);                        
disp('Adding noise to the data in Fourier domain');
Y = Y_full + kSpaceNoise;                                                                                                         %add noise to the data, complex white noise with sigma=0.5
disp('Under-sampling the noisy data in Fourier domain');
Y = sampling_matrix.*Y;                                                                                                             %uder-sampling the noised data

%% build contrasts using conventional MRF
disp('Extracting the parameter maps using matched filter');
X_estimated_old_mrf = reshape(fft_mats(Y_full,2),N,N,L);                                                              %Fully sampled non-noised data, used as reference

% estimate maps using matched filter for conventional MRF solution
E_matched_filter_old_mrf = full(find_E_fast(X_estimated_old_mrf,D));                                         %results is one-sparse E
[T1_old_mrf,T2_old_mrf,PD_old_mrf] = build_maps_from_E(E_matched_filter_old_mrf,LUT);   %restore the quatitative maps from E and LUT

%% FLOR algorithm
disp('Calculating the parameter maps using FLOR');
r = L;
th = 5;
[ X_estimated_flor, E_estimated_flor] = florAlg( Y,D,N,L,X,r,th );
[T1_flor,T2_flor,PD_flor] = build_maps_from_E(E_estimated_flor,LUT);
%% Show Results in the region of interest
T1.orig = T1_128;                                                T2.orig = T2_128;                                                      PD.orig = PD_128;
T1.old_mrf = T1_old_mrf.*(T1.orig~=0);            T2.old_mrf = T2_old_mrf.*(T2.orig~=0);                 PD.old_mrf = PD_old_mrf.*(PD.orig~=0);
T1.flor = T1_flor.*(T1.orig~=0);                           T2.flor = T2_flor.*(T2.orig~=0);                                PD.flor = PD_flor.*(PD.orig~=0);
showResults( k_space_undersampling_ratio,T1,T2,PD );