%% Initialize:
addpath('Bloch\');
N=128;                                                               %The image size is NxN
L = 500;                                                             %The sequence length
load input_to_fisp_experiment                        %load the quantitative maps
[RFpulses, TR]=generate_RF_TR(L);            %Load slowly changing RF and TR values
RFpulses = RFpulses*1i;                                %to avoid complex values of X and D
TE = 10;%2
load('SPURS_settings.mat');                         %For SPURS algorithm
setenv('SPURS_DIR', 'spurs_directory_path\SPURS_DEMO');    %set spurs_directory_path to SPURS_DEMO directory on your computer, like: 'c:\...'
%% build dictionary using MRF FISP sequence, omit entries where T2>T1
if exist('D.mat')~=0                                                                                                         % you can save X, D, and LUT to D.mat to save time
    load D.mat;
else
    disp('Building the dictionary...');
    [FISP_dictionary,LUT] = build_dictionary_fisp(L,RFpulses,TR,TE);                     %build the MRF FISP dictionary and its matching look up table
    D = single(FISP_dictionary);
    clear FISP_dictionary;
    LUT = LUT*1000;                                                                                                        %change units
    disp('The dictionary is ready, building the temporal images...');
    X = build_fully_sampled_contrasts(RFpulses ,TR ,TE, T1_128,T2_128,PD_128);  %build the fully sampled temporal contrasts
    disp('The images are ready');
end

%% undersample the data in Fourier domain 

% Generate spiral sampling trajectories
num_of_TRs = L;
%Magnet parameters
smax=17000;                                 %(=170 mT/m/ms in Siemens)
gmax=4;                                         %(=40 mT/m)
T=0.00001;
%for inner region (10x10 central k-space)
inner_region_size=20;
N_inner=1;                                      %Number of interleaves
N_outer=24;
N_pixels=N;                                    %128x128 slice is obtained
FOV=24;
[sampling_locations_spiral, num_samples_inner, num_samples_outer]=spiral_trajectories_fisp(num_of_TRs,smax,gmax,T,inner_region_size,N_inner,N_outer,N_pixels,FOV);
[sampling_locations_spiral, samples_locations_complex]=normalize_sampling_locations(sampling_locations_spiral,N_pixels);
% Sample the data with spiral trajectories
Y_spiral = sample_k_spaces(sampling_locations_spiral,reshape(X,N,N,L));
% Add noise to the sampled data
kSpaceNoise =  reshape([1 1i]*0.5*randn(2,L*N^2),N,L*N);
spiral_noise = sample_k_spaces(sampling_locations_spiral,reshape(kSpaceNoise,N,N,L));
Y_spiral_noised = cellfun(@plus,Y_spiral,spiral_noise,'UniformOutput',false);

% sampled_k_space_data has num_of_TRs celss, and each cell holds the
% sampling locations and the k_space values for each TR
cell_dimensions=zeros(1,L);
for i=1:length(Y_spiral_noised)
    cell_dimensions(i)=size(Y_spiral_noised{i},1);
end 

%% build contrasts using conventional MRF
disp('Extracting the parameter maps using matched filter');
%Fully sampled non-noised data, used as reference:
X_estimated_old_mrf = X;                                                             

% estimate maps using matched filter for conventional MRF solution
E_matched_filter_old_mrf = full(find_E_fast(X_estimated_old_mrf,D));                                         %results is one-sparse E
[T1_old_mrf,T2_old_mrf,PD_old_mrf] = build_maps_from_E(E_matched_filter_old_mrf,LUT);   %restore the quatitative maps from E and LUT

%% FLOR algorithm
disp('Calculating the parameter maps using FLOR');
th = 5; 
[ X_estimated_flor, E_estimated_flor] = florAlgSpiral( Y_spiral_noised,sampling_locations_spiral,cell_dimensions,D,N,L,X,th );
[T1_flor,T2_flor,PD_flor] = build_maps_from_E(E_estimated_flor,double(LUT));                             %restore the quatitative maps from E and LUT

%% Show Results in the region of interest
T1.orig = T1_128;                                                T2.orig = T2_128;                                                      PD.orig = PD_128;
T1.old_mrf = T1_old_mrf.*(T1.orig~=0);            T2.old_mrf = T2_old_mrf.*(T2.orig~=0);                 PD.old_mrf = PD_old_mrf.*(PD.orig~=0);
T1.flor = T1_flor.*(T1.orig~=0);                           T2.flor = T2_flor.*(T2.orig~=0);                                PD.flor = PD_flor.*(PD.orig~=0);
showResults( (num_samples_inner+num_samples_outer)/(N^2),T1,T2,PD );