% This function returns a struct, where we can update the parameters
% of the modulated wideband converter system.

function MWCStruct = ConstructDefaultMWCStruct()
MWCStruct = struct;

% - Model paratmeters -
MWCStruct = setfield(MWCStruct, 'm', 40);   % number of channels
MWCStruct = setfield(MWCStruct, 'M', 195);  % number of alternations

MWCStruct = setfield(MWCStruct, 'fcut', 10e9/195/2);   % filter cutoff
MWCStruct = setfield(MWCStruct, 'Ts', 195/10e9);   % sampling rate per channel

% periodic waveforms
MWCStruct = setfield(MWCStruct, 'Speed', 10e9);
MWCStruct = setfield(MWCStruct, 'SincPatternVariableName', 'Signs');  % load an mXM matrix from workspace

