% This function returns a struct, where we can update the parameters
% required for signal generation.

function SigStruct = ConstructDefaultSignalStruct()
SigStruct = struct;

% - Model paratmeters -
SigStruct = setfield(SigStruct, 'N', 6);   % number of bands
SigStruct = setfield(SigStruct, 'B', 50e6);   % maximal width of a single band
SigStruct = setfield(SigStruct, 'fmax', 5e9);   % maximal frequency, Nyquist rate = 2fmax

% - Advanced configuration - 

% below there is a list of all fields that may be needed to specify the
% signal. The default options are selected at the bottom.

% Signal type (supported:  sum of sinc, BPSK or QPSK)
SigStruct = setfield(SigStruct, 'Type', 'sinc');
SigStruct = setfield(SigStruct, 'SincDuration', 1e-6);
SigStruct = setfield(SigStruct, 'SincEnergies', 'random');
SigStruct = setfield(SigStruct, 'SincEnergies', 'specify');
SigStruct = setfield(SigStruct, 'SincEnergiesString', '1;2;3');
SigStruct = setfield(SigStruct, 'SincDelays', 'random');
SigStruct = setfield(SigStruct, 'SincDelays', 'specify');
SigStruct = setfield(SigStruct, 'SincDelayString', '0.4e-6;0.7e-6;0.2e-6'); % times the duration

SigStruct = setfield(SigStruct, 'Type', 'bpsk');
SigStruct = setfield(SigStruct, 'BPSK_Tsymbol', 1e-6);
SigStruct = setfield(SigStruct, 'BPSKEnergies', 'random');
SigStruct = setfield(SigStruct, 'BPSKEnergies', 'specify');
SigStruct = setfield(SigStruct, 'BPSKEnergiesString', '1;2;3');
SigStruct = setfield(SigStruct, 'BPSK_NumSymbols', 150);
SigStruct = setfield(SigStruct, 'BPSK_pulseshape', 'sinc');
SigStruct = setfield(SigStruct, 'BPSK_pulseshape', 'raised-cosine');
SigStruct = setfield(SigStruct, 'BPSK_pulseshape_rolloff', 0.2);

SigStruct = setfield(SigStruct, 'Type', 'qpsk');
SigStruct = setfield(SigStruct, 'QPSK_Tsymbol', 1e-6);
SigStruct = setfield(SigStruct, 'QPSKEnergies', 'random');
SigStruct = setfield(SigStruct, 'QPSKEnergies', 'specify');
SigStruct = setfield(SigStruct, 'QPSKEnergiesString', '1;2;3');
SigStruct = setfield(SigStruct, 'QPSK_NumSymbols', 150);
SigStruct = setfield(SigStruct, 'QPSK_pulseshape', 'sinc');
SigStruct = setfield(SigStruct, 'QPSK_pulseshape', 'raised-cosine');
SigStruct = setfield(SigStruct, 'QPSK_pulseshape_rolloff', 0.2);

% Noise
SigStruct = setfield(SigStruct, 'SNR', 30); % in dB, over the wideband regime

% Carriers
SigStruct = setfield(SigStruct, 'Carriers', 'random'); 
SigStruct = setfield(SigStruct, 'Carriers', 'specify'); 
SigStruct = setfield(SigStruct, 'CarrierString', '1.2e6;3e6;4.3e6'); 

% - Default values -
SigStruct = setfield(SigStruct, 'SincEnergies', 'random');
SigStruct = setfield(SigStruct, 'SincDelays', 'random');
SigStruct = setfield(SigStruct, 'BPSK_Tsymbol', 1e-6);
SigStruct = setfield(SigStruct, 'BPSKEnergies', 'random');
SigStruct = setfield(SigStruct, 'BPSK_pulseshape', 'sinc');
SigStruct = setfield(SigStruct, 'Type', 'qpsk');
SigStruct = setfield(SigStruct, 'QPSK_Tsymbol', 1e-6);
SigStruct = setfield(SigStruct, 'QPSKEnergies', 'random');
SigStruct = setfield(SigStruct, 'QPSK_pulseshape', 'sinc');
SigStruct = setfield(SigStruct, 'SNR', 30); % in dB, over the wideband regime
SigStruct = setfield(SigStruct, 'Carriers', 'random'); 
