function varargout = Xampling(varargin)
% XAMPLING M-file for Xampling.fig
%      XAMPLING, by itself, creates a new XAMPLING or raises the existing
%      singleton*.
%
%      H = XAMPLING returns the handle to a new XAMPLING or the handle to
%      the existing singleton*.
%
%      XAMPLING('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in XAMPLING.M with the given input arguments.
%
%      XAMPLING('Property','Value',...) creates a new XAMPLING or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Xampling_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Xampling_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% editsamplessize the above text to modify the response to help Xampling

% Last Modified by GUIDE v2.5 09-Feb-2010 08:48:23

% Begin initialization code - DO NOT EDITSAMPLESSIZE
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @Xampling_OpeningFcn, ...
    'gui_OutputFcn',  @Xampling_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDITSAMPLESSIZE


% --- Executes just before Xampling is made visible.
function Xampling_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Xampling (see VARARGIN)

% Choose default command line output for Xampling
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Xampling wait for user response (see UIRESUME)
% uiwait(handles.Xampling);
myfilename = mfilename('fullpath');
n= regexp(lower(myfilename),'(.*)xampling\\xampling','tokens');
addpath(genpath(cell2mat(n{1})))
%addpath(genpath(sprintf('%s\\%s',matlabroot,'toolbox\matlab\randfun\')))

% Read in image
imageArray =imread('SignalImg2.bmp');
% Switch active axes to the one you made for the image.
axes(handles.axesSignalImg);
% Put the image array into the axes so it will appear on the GUI
imshow(imageArray);
% Add labels to the Plots
ylabel(handles.TimePlot,'Amplitude');
ylabel(handles.FreqPlot,'Magnitude (dB)');

ylabel(handles.SimulationOriginalaxes,'Amplitude');
ylabel(handles.SimulationReconaxes,'Amplitude');

%  Make The progress bar invisible
ClearBar(handles);
set(handles.uneditStatus,'String','Status: Ready (waiting for user input)');
turn2gray=struct2cell(handles);
for k=1:size(turn2gray,1)
    if isfield(get(turn2gray{k}), 'BackgroundColor')
        if isfield(get(turn2gray{k}),'Style') && ~strcmp(get(turn2gray{k},'Style'),'edit')
            set(turn2gray{k}, 'BackgroundColor', [0.831373 0.815686 0.784314]);
        elseif ~isfield(get(turn2gray{k}),'Style')
            set(turn2gray{k}, 'BackgroundColor', [0.831373 0.815686 0.784314]);
        end
    end
    if isfield(get(turn2gray{k}), 'Color')
        set(turn2gray{k}, 'Color', [0.831373 0.815686 0.784314]);
    end
end
set(handles.Xampling,'Color',[0.831373 0.815686 0.784314]);
%set(handles.radioQCZ, 'BackgroundColor',[0.72 0.89 1]);
%set(handles.radioVCU, 'BackgroundColor',[0.72 0.89 1]);
set(handles.textSFailure, 'BackgroundColor',[1 0 0]);
handles.Simulated=0; % Bool 1 - if simulation ran 0 - else
ResetSignalBtn_Callback(hObject, eventdata, handles)
handles.Signal=[];

handles.SNR=3;
handles.carrier=[300 2700 4320];
handles.start=0;
handles.end=100;
handles.TimeInst=10;
handles.Ready4Simulation=1; % Bool 1 - if ready 0 - else
handles.SignalOK=0;
handles.SamplingOK=0;
handles.ReconstructOK=0;
handles.Simulated=0; % Bool 1 - if simulation ran 0 - else
handles.ShowWarningAgain=1;
handles.SignalChanged=1;
handles.SamplingChanged=1;
handles.ReconstructChanged=1;
handles.SamplingVisited=0;
handles.ReconstructVisited=0;

handles.SigStruct = ConstructDefaultSignalStruct();
set(handles.editN,'String',num2str(handles.SigStruct.N));
set(handles.editB,'String',num2str(handles.SigStruct.B*1e-6));
set(handles.editFmax,'String',num2str(handles.SigStruct.fmax*1e-9));

set(handles.TimePlot,'XTick',[]);
set(handles.TimePlot,'YTick',[]);
set(handles.FreqPlot,'XTick',[]);
set(handles.FreqPlot,'YTick',[]);
set(handles.SimulationOriginalaxes,'XTick',[]);
set(handles.SimulationOriginalaxes,'YTick',[]);
set(handles.SimulationReconaxes,'XTick',[]);
set(handles.SimulationReconaxes,'YTick',[]);
handles.isZoomIn=0;
handles.isZoomOut=0;
% Update handles structure
guidata(hObject, handles);


%movegui(handles.Xampling,'northwest');
%set(gcf, 'CreateFcn', {@movegui,'northwest'});

% So the 'Never show this dialog again' will be shown in each run
getpref('Xampling','ChangeWarning','1.0');
rmpref('Xampling','ChangeWarning');


% --- Outputs from this function are returned to the command line.
function varargout = Xampling_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --------------------------------------------------------------------
function fileMenu_Callback(hObject, eventdata, handles)
% hObject    handle to fileMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function helpMenu_Callback(hObject, eventdata, handles)
% hObject    handle to helpMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function helpHelpMenu_Callback(hObject, eventdata, handles)
% hObject    handle to helpHelpMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% guiGettingStarted=GettingStarted;
% movegui(guiGettingStarted,'center');

if strcmp(get(handles.SignalGraphsPanel,'Visible'),'on')
    web http://webee.technion.ac.il/Sites/People/YoninaEldar/Info/software/GUI/MWC_GUI.htm#Screen1 -browser
elseif strcmp(get(handles.SampleParamPanel,'Visible'),'on')
    web http://webee.technion.ac.il/Sites/People/YoninaEldar/Info/software/GUI/MWC_GUI.htm#Screen2 -browser
elseif strcmp(get(handles.DrawingReconstructPanel,'Visible'),'on')
    web http://webee.technion.ac.il/Sites/People/YoninaEldar/Info/software/GUI/MWC_GUI.htm#Screen3 -browser
elseif strcmp(get(handles.SimulationGraphPanel,'Visible'),'on')
    web http://webee.technion.ac.il/Sites/People/YoninaEldar/Info/software/GUI/MWC_GUI.htm#Screen4 -browser
else
    web http://webee.technion.ac.il/Sites/People/YoninaEldar/Info/software/GUI/MWC_GUI.htm#Screen1 -browser
end
    



% --------------------------------------------------------------------
function aboutHelpMenu_Callback(hObject, eventdata, handles)
% hObject    handle to aboutHelpMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
guiGettingStarted=GettingStarted;
movegui(guiGettingStarted,'center')

% --- Executes on button press in SignalMenuBtn.
function SignalMenuBtn_Callback(hObject, eventdata, handles)
% hObject    handle to SignalMenuBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.SignalGraphsPanel,'Visible','On');
set(handles.CarrierPanel,'Visible','Off');
set(handles.SignalParamPanel,'Visible','On');
set(handles.SampleParamPanel,'Visible','Off');
set(handles.SampleDrawing,'Visible','Off');
%set(handles.FrameReconstructPanel,'Visible','Off');
%set(handles.CSReconstructPanel,'Visible','Off');
set(handles.DrawingReconstructPanel,'Visible','Off');

set(handles.SimulateRunPanel,'Visible','Off');
set(handles.SimulationGraphPanel,'Visible','Off');
handles.SamplingVisited=0;
handles.ReconstructVisited=0;
set(handles.signalProgressPanel,'Parent',handles.SignalGraphsPanel)







% --- Executes on button press in SampleMenuBtn.
function SampleMenuBtn_Callback(hObject, eventdata, handles)
% hObject    handle to SampleMenuBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.SignalGraphsPanel,'Visible','Off');
set(handles.CarrierPanel,'Visible','Off');
set(handles.SignalParamPanel,'Visible','Off');
set(handles.SampleParamPanel,'Visible','On');
%set(handles.FrameReconstructPanel,'Visible','Off');
%set(handles.CSReconstructPanel,'Visible','Off');
set(handles.DrawingReconstructPanel,'Visible','Off');

set(handles.SimulateRunPanel,'Visible','Off');
set(handles.SimulationGraphPanel,'Visible','Off');
set(handles.signalProgressPanel,'Parent',handles.SampleParamPanel)


% Autosets the values of m/Fp/Tp/Fs/Ts/Cut off
% SampleAutoSetBtn_Callback(hObject, eventdata, handles);
handles.MWC.m=str2double(get(handles.editM,'String'));
handles.MWC.fcut=1e6*str2double(get(handles.editCutoff,'String'));

set(handles.SampleDrawing,'Visible','On');
imageArray =imread('SampleSystem.bmp');
% Switch active axes to the one you made for the image.
axes(handles.axesSampleImage);
% Put the image array into the axes so it will appear on the GUI
imshow(imageArray);

imageArray =imread('SigDevice.jpg');
% Switch active axes to the one you made for the image.
axes(handles.axesSignalDevice);
% Put the image array into the axes so it will appear on the GUI
imshow(imageArray);



% % Check Validity.
% if handles.SignalOK==0
%     if(mod(str2double(get(handles.editN,'String')),2)==0)
%         if (str2double(get(handles.editN,'String'))*str2double(get(handles.editB,'String'))<1e3*str2double(get(handles.editFmax,'String')))
%             if not(sum(get(handles.editN,'ForegroundColor')))
%                 if not(sum(get(handles.editB,'ForegroundColor')))
%                     if not(sum(get(handles.editFmax,'ForegroundColor')))
%                         handles.SignalOK=1;
%                     end
%                 end
%             end
%         end
%     end
% end
% if handles.SignalOK==0
%     msgbox('Error in Signal, Simulation will be possible only after the error will be fixed');
% else
% end
% handles.ReconstructVisited=0;

if handles.SignalChanged == 1
    handles.SigStruct.B=1e6*str2double(get(handles.editB,'String'));
    handles.SigStruct.N=str2double(get(handles.editN,'String'));
    handles.SigStruct.fmax=1e9*str2double(get(handles.editFmax,'String'));
    
    handles.MWC = ConstructDefaultMWCstruct();
    
    set(handles.editM,'String',num2str(handles.MWC.m));
    set(handles.editFs,'String',num2str(1e-6/handles.MWC.Ts));
    set(handles.editAltSpeed,'String',num2str(handles.MWC.M));
    set(handles.editCutoff,'String',num2str(1e-6*handles.MWC.fcut));
    set(handles.editAltSpeed,'String',num2str(1e-9*handles.MWC.Speed));
    
    set(handles.textTotalSampling,'String',num2str((1e-6/handles.MWC.Ts)*handles.MWC.m));
    set(handles.textNyq,'String',num2str(2*1000*handles.SigStruct.fmax/1e9));
    %         set(handles.textInvTp,'String',['1/Tp = ' num2str(round(100*1e-6*handles.MWC.Speed/handles.MWC.M)/100) ' MHz']);
    %         set(handles.textTp,'String',['Tp = ' num2str(round(100*1e9*handles.MWC.M/handles.MWC.Speed)/100) ' nanosec']);
    
    set(handles.editFs,'ForegroundColor',[0 0 0]);
    set(handles.editAltSpeed,'ForegroundColor',[0 0 0]);
    set(handles.editSigAlt,'ForegroundColor',[0 0 0]);
    handles.SignalChanged=0;
    handles.SamplingOK=0;
end
% Update handles structure
guidata(hObject, handles);


% --- Executes on button press in ReconMenuBtn.
function ReconMenuBtn_Callback(hObject, eventdata, handles)
% hObject    handle to ReconMenuBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set(handles.SignalGraphsPanel,'Visible','Off');
set(handles.CarrierPanel,'Visible','Off');
set(handles.SignalParamPanel,'Visible','Off');
set(handles.SampleParamPanel,'Visible','Off');
set(handles.SampleDrawing,'Visible','Off');
%set(handles.FrameReconstructPanel,'Visible','on');
%set(handles.CSReconstructPanel,'Visible','on');
set(handles.DrawingReconstructPanel,'Visible','on');
set(handles.SimulateRunPanel,'Visible','Off');
set(handles.SimulationGraphPanel,'Visible','Off');

set(handles.SampleDrawing,'Visible','On');
imageArray =imread('SupportRecovery4.bmp');
% Switch active axes to the one you made for the image.
axes(handles.axesReconstructImage);
% Put the image array into the axes so it will appear on the GUI
imshow(imageArray);
imageArray =imread('SupportText3.bmp');
% Switch active axes to the one you made for the image.
axes(handles.axesSupportText);
% Put the image array into the axes so it will appear on the GUI
imshow(imageArray);
if handles.SamplingVisited==1
    handles.S = CalculateSupport(handles.Signal,handles.MWC);
    %set(handles.editFrameLength,'String',num2str(min(30, length(handles.Samples))));
    set(handles.editSamplesSize,'String',num2str(length(handles.Samples)));
    set(handles.textS,'String',['[ ' num2str(handles.S) ' ]']);
    
else
    %set(handles.editFrameLength,'String','???');
end

%     % Check Validity.
%     if handles.SamplingOK==0
%                 handles.SamplingOK=1;
%     end
%
%
%     if handles.SamplingOK==0
%         msgbox('Error in Sampling, Simulation will be possible only after the error will be fixed');
%     else
%         handles.ReconstructVisited=1;
%     end
set(handles.signalProgressPanel,'Parent',handles.DrawingReconstructPanel);
% Update handles structure
guidata(hObject, handles);


% --- Executes on button press in SimMenuBtn.
function SimMenuBtn_Callback(hObject, eventdata, handles)
% hObject    handle to SimMenuBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% if  handles.ReconstructVisited==1 && handles.SamplingVisited==1
set(handles.SignalGraphsPanel,'Visible','Off');
set(handles.CarrierPanel,'Visible','Off');
set(handles.SignalParamPanel,'Visible','Off');
set(handles.SampleDrawing,'Visible','Off');
set(handles.SampleParamPanel,'Visible','Off');
%set(handles.FrameReconstructPanel,'Visible','Off');
%set(handles.CSReconstructPanel,'Visible','Off');
set(handles.DrawingReconstructPanel,'Visible','Off');
set(handles.SimulateRunPanel,'Visible','on');
set(handles.SimulationGraphPanel,'Visible','on');
% Read in image
imageArray =imread('ReconstructionScreen2.bmp');
% Switch active axes to the one you made for the image.
axes(handles.axesReconImage);
% Put the image array into the axes so it will appear on the GUI
imshow(imageArray);
% Read in image
%imageArray =imread('Pics\SquaredError.bmp');
% Switch active axes to the one you made for the image.
%axes(handles. axesSqrErrImg);
% Put the image array into the axes so it will appear on the GUI
imshow(imageArray);

if handles.ReconstructVisited==1
else
%    set(handles.uneditSqrErr,'String','???');
end

% Check Validity.
if handles.ReconstructOK==0
    % Since there is no invalid input this check is only for future uses
    handles.ReconstructOK=1;
end
set(handles.signalProgressPanel,'Parent',handles.SimulationGraphPanel)
% Update handles structure
guidata(hObject, handles);
% else
%     if handles.SamplingVisited==0
%         msgbox('You must enter the Sampling tab before the Simulation tab');
%     else
%         msgbox('You must enter the Reconstruct tab before the Simulation tab');
%     end
% end



function editN_Callback(hObject, eventdata, handles)
% hObject    handle to editN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editN as text
%        str2double(get(hObject,'String')) returns contents of editN as a double
handles.SigStruct.N=str2double(get(handles.editN,'String'));
if(mod(str2double(get(handles.editN,'String')),2)==0)
    
else
    msgbox('N must be even, Changing back to default');
    set(handles.editN,'String',num2str(6)); %%%%%% Notice I have no way of extracting particular default values 
end
if(str2double(get(handles.editN,'String'))*1e6*str2double(get(handles.editB,'String'))<1e9*str2double(get(handles.editFmax,'String')))
    handles.SigStruct.N=str2double(get(handles.editN,'String'));
else
    msgbox('fmax must be greater then N*B, Changing back to default');
   set(handles.editN,'String',num2str(6)); %%%%%% Notice I have no way of extracting particular default values 
   handles.SigStruct.N=str2double(get(handles.editN,'String'));
end

if handles.SignalOK==1
    resetSignalPlots(hObject, eventdata, handles);
    resetReconPlots(hObject, eventdata, handles);
    set(handles.drawSignalBtn,'Enable','off');
    set(handles.drawRandBtn, 'Enable', 'off');
    handles.SignalOK=0;
    handles.SamplingVisited=0;
    handles.ReconstructVisited=0;
    set(handles.textStilda,'String','[  ]');
    set(handles.textSFailure,'String','???');
    set(handles.textSFailure,'ForegroundColor', [1 1 1]);
    set(handles.textSFailure,'BackgroundColor', [1 0 0]);
end

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function editN_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: editSamplesSize controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




function editB_Callback(hObject, eventdata, handles)
% hObject    handle to editB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editB as text
%        str2double(get(hObject,'String')) returns contents of editB as a double
handles.SigStruct.B=1e6*str2double(get(handles.editB,'String'));

if(str2double(get(handles.editN,'String'))*1e6*str2double(get(handles.editB,'String'))<1e9*str2double(get(handles.editFmax,'String')))
    
else
    msgbox('fmax must be greater then N*B, Changing back to default');
   set(handles.editB,'String',num2str(50)); %%%%%% Notice I have no way of extracting particular default values 
end
 handles.SigStruct.B=1e6*str2double(get(handles.editB,'String'));


if handles.SignalOK==1
    resetSignalPlots(hObject, eventdata, handles);
    resetReconPlots(hObject, eventdata, handles);
    set(handles.drawSignalBtn,'Enable','off');
    set(handles.drawRandBtn, 'Enable', 'off');
    handles.SignalOK=0;
    handles.SamplingVisited=0;
    handles.ReconstructVisited=0;
    set(handles.textStilda,'String','[  ]');
    set(handles.textSFailure,'String','???');
    set(handles.textSFailure,'ForegroundColor', [1 1 1]);
    set(handles.textSFailure,'BackgroundColor', [1 0 0]);
end

% Update handles structure
guidata(hObject, handles);




% --- Executes during object creation, after setting all properties.
function editB_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: editSamplesSize controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editFmax_Callback(hObject, eventdata, handles)
% hObject    handle to editFmax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editFmax as text
%        str2double(get(hObject,'String')) returns contents of editFmax as a double
handles.SigStruct.fmax=1e9*str2double(get(handles.editFmax,'String'));
if(str2double(get(handles.editN,'String'))*1e6*str2double(get(handles.editB,'String'))<1e9*str2double(get(handles.editFmax,'String')))

else
    msgbox('fmax must be greater then N*B, Changing back to default');
   set(handles.editFmax,'String',num2str(5)); %%%%%% Notice I have no way of extracting particular default values 
end
handles.SigStruct.fmax=1e9*str2double(get(handles.editFmax,'String'));

% Since Data was changed a new validity check is necessary
if handles.SignalOK==1
    resetSignalPlots(hObject, eventdata, handles);
    resetReconPlots(hObject, eventdata, handles);
    set(handles.drawSignalBtn,'Enable','off');
    set(handles.drawRandBtn, 'Enable', 'off');
    handles.SignalOK=0;
    handles.SamplingVisited=0;
    handles.ReconstructVisited=0;
    set(handles.textStilda,'String','[  ]');
    set(handles.textSFailure,'String','???');
    set(handles.textSFailure,'ForegroundColor', [1 1 1]);
    set(handles.textSFailure,'BackgroundColor', [1 0 0]);
end

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editFmax_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editFmax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: editSamplesSize controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in ResetSignalBtn.
function ResetSignalBtn_Callback(hObject, eventdata, handles)
% hObject    handle to ResetSignalBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in PlotTimeSignalBtn.
function PlotTimeSignalBtn_Callback(hObject, eventdata, handles)
% hObject    handle to PlotTimeSignalBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%Set to Empty
if handles.SignalOK==0  
    % OMRI: here we need to check that N is even + NB<fmax. we return error if not.
    %     handles.SigStruct.N=handles.N;
    %     handles.SigStruct.B=1e6*handles.B;
    %     handles.SigStruct.fmax=1e9*handles.fmax;
    handles.Signal = GenerateSignal(handles.SigStruct);
end
handles.SignalOK=1;

%Set to Empty
CleanBar(handles);
%Show Bar
ShowBar(handles);
Npts=str2num(get(handles.editNpts,'String'));
set(handles.uneditStatus,'String','Status: Busy, Generating signal');
CleanBar(handles)
fnyq = 2*handles.Signal.Structure.fmax;
[handles.SignalAmp, handles.NoiseAmp, handles.TimeAxis] = GenerateSignalValues(handles.Signal,1/fnyq,Npts,handles); % Res=1/20e7
ClearBar(handles);
set(handles.uneditProgPrecent,'String','');
set(handles.uneditStatus,'String','Status: Ready (waiting for user input)');


if handles.SignalOK==1
    CleanBar(handles);
    
    %Show Bar
    ShowBar(handles);
    set(handles.uneditStatus,'String','Status: Busy, Preparing plots');
    CleanBar(handles)
    updateProgBar(20,handles,50);
    ClearBar(handles)
    axes(handles.TimePlot);
    Sig = handles.SignalAmp + handles.NoiseAmp;
    temp=handles.TimePlot;
    handles.TimePlot=plot(handles.TimeAxis,Sig);
    xlabel('Time (sec)')
    ylabel('Amplitude');
    handles.TimePlot=temp;
    axes(handles.FreqPlot);
    dt = handles.TimeAxis(2)-handles.TimeAxis(1);
    fs = 1/dt;
    if get(handles.radioPSD,'Value')==1.0
        temp=handles.FreqPlot;
        pwelch(Sig,[],[],[],fs);
        handles.FreqPlot=temp;       
    else
        f_axis = linspace(-fs/2,fs/2,length(handles.TimeAxis));
        Fsig = fftshift((fft(Sig)));
        temp=handles.FreqPlot;
        zero_loc = min(find(f_axis>0));
        handles.FreqPlot=plot(f_axis(zero_loc:end),20*log10(abs(Fsig(zero_loc:end))));
        xlabel('Frequency (Hz)')
        ylabel('Magnitude (dB)');
        axis tight;
        handles.FreqPlot=temp;
    end
    set(handles.uneditProgPrecent,'String','');
    set(handles.uneditStatus,'String','Status: Ready (waiting for user input)');
    % Update handles structure
    ClearBar(handles)
    % handles.Time_Axis=TimeAxis;
    
    set(handles.drawSignalBtn,'Enable','on')
    guidata(hObject, handles);
else
    errordlg( 'The signal must be drawn first.','Signal Error.');
end

function editSNR_Callback(hObject, eventdata, handles)
% hObject    handle to editSNR (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editSNR as text
%        str2double(get(hObject,'String')) returns contents of editSNR as a double
% Since Data was changed a new validity check is necessary
handles.SignalOK=0;
handles.SamplingVisited=0;
handles.ReconstructVisited=0;
if handles.Simulated==1
    showWarningMsg();
    handles.SignalChanged=1;
end

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editSNR_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editSNR (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: editSamplesSize controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on key press with focus on editN and none of its controls.
function editN_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to editN (see GCBO)
% eventdata  structure with the following fields (see UICONTROL)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-Sampling-%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



function editM_Callback(hObject, eventdata, handles)
% hObject    handle to editM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editM as text
%        str2double(get(hObject,'String')) returns contents of editM as a double
handles.MWC.m=str2double(get(handles.editM,'String'));
set(handles.textTotalSampling,'String',num2str((1e-6/handles.MWC.Ts)*handles.MWC.m));

% Since Data was changed a new validity check is necessary
if handles.SamplingVisited==1
    resetReconPlots(hObject, eventdata, handles);
    set(handles.drawRandBtn, 'Enable', 'off');
    handles.SamplingVisited=0;
    handles.ReconstructVisited=0;
    set(handles.textStilda,'String','[  ]');
    set(handles.textSFailure,'String','???');
    set(handles.textSFailure,'ForegroundColor', [1 1 1]);
    set(handles.textSFailure,'BackgroundColor', [1 0 0]);
end


% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editM_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editM (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: editSamplesSize controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editCutoff_Callback(hObject, eventdata, handles)
% hObject    handle to editCutoff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editCutoff as text
%        str2double(get(hObject,'String')) returns contents of editCutoff as a double
handles.MWC.fcut=str2double(get(handles.editCutoff,'String'));

% Since Data was changed a new validity check is necessary
if handles.SamplingVisited==1
    resetReconPlots(hObject, eventdata, handles);
    set(handles.drawRandBtn, 'Enable', 'off');
    handles.SamplingVisited=0;
    handles.ReconstructVisited=0;
    set(handles.textStilda,'String','[  ]');
    set(handles.textSFailure,'String','???');
    set(handles.textSFailure,'ForegroundColor', [1 1 1]);
    set(handles.textSFailure,'BackgroundColor', [1 0 0]);
end

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editCutoff_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editCutoff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: editSamplesSize controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% Makes the proper adjustments for simple mode


% --- Executes on button press in SampleAutoSetBtn.
function SampleAutoSetBtn_Callback(hObject, eventdata, handles)
% hObject    handle to SampleAutoSetBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles.MWC = Auto_Set_MWC(handles.SigStruct.N,handles.SigStruct.B,handles.SigStruct.fmax);
set(handles.editM,'String',num2str(handles.MWC.m));
set(handles.editFs,'String',num2str(1e-6/handles.MWC.Ts));
set(handles.editCutoff,'String',num2str(1e-6*handles.MWC.fcut));
set(handles.editAltSpeed,'String',num2str(1e-9*handles.MWC.Speed));

set(handles.textTotalSampling,'String',num2str((1e-6/handles.MWC.Ts)*handles.MWC.m));
set(handles.textNyq,'String',num2str(2*1000*handles.SigStruct.fmax/1e9));
%     set(handles.textInvTp,'String',['1/Tp = ' num2str(round(100*1e-6*handles.MWC.Speed/handles.MWC.M)/100) ' MHz']);
%     set(handles.textTp,'String',['Tp = ' num2str(round(100*1e9*handles.MWC.M/handles.MWC.Speed)/100) ' nanosec']);
%
set(handles.editFs,'ForegroundColor',[0 0 0]);
set(handles.editAltSpeed,'ForegroundColor',[0 0 0]);
set(handles.editSigAlt,'ForegroundColor',[0 0 0]);

% Since Data was changed a new validity check is necessary
if handles.SamplingVisited==1
    resetReconPlots(hObject, eventdata, handles);
    set(handles.drawRandBtn, 'Enable', 'off');
    handles.SamplingVisited=0;
    handles.ReconstructVisited=0;
    set(handles.textStilda,'String','[  ]');
    set(handles.textSFailure,'String','???');
    set(handles.textSFailure,'ForegroundColor', [1 1 1]);
    set(handles.textSFailure,'BackgroundColor', [1 0 0]);
end

% Update handles structure
guidata(hObject, handles);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-Reconstruct-%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



function editReconAdvnced1_Callback(hObject, eventdata, handles)
% hObject    handle to editReconAdvnced1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editReconAdvnced1 as text
%        str2double(get(hObject,'String')) returns contents of editReconAdvnced1 as a double
handles.ReconAdvnced1=str2double(get(handles.editReconAdvnced1,'String'));


% Since Data was changed a new validity check is necessary
handles.ReconstructOK=0;
if handles.Simulated==1
    showWarningMsg();
    handles.ReconstructChanged=1;
end

% Update handles structure
guidata(hObject, handles);



% --- Executes during object creation, after setting all properties.
function editReconAdvnced1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editReconAdvnced1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: editSamplesSize controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function editReconAdvnced2_Callback(hObject, eventdata, handles)
% hObject    handle to editReconAdvnced2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editReconAdvnced2 as text
%        str2double(get(hObject,'String')) returns contents of editReconAdvnced2 as a double
handles.ReconAdvnced2=str2double(get(handles.editReconAdvnced2,'String'));


% Since Data was changed a new validity check is necessary
handles.ReconstructOK=0;
if handles.Simulated==1
    showWarningMsg();
    handles.ReconstructChanged=1;
end

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editReconAdvnced2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editReconAdvnced2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: editSamplesSize controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editReconAdvnced3_Callback(hObject, eventdata, handles)
% hObject    handle to editReconAdvnced3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editReconAdvnced3 as text
%        str2double(get(hObject,'String')) returns contents of editReconAdvnced3 as a double
handles.ReconAdvnced3=str2double(get(handles.editReconAdvnced3,'String'));

% Since Data was changed a new validity check is necessary
handles.ReconstructOK=0;
if handles.Simulated==1
    showWarningMsg();
    handles.ReconstructChanged=1;
end

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editReconAdvnced3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editReconAdvnced3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: editSamplesSize controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% function editFrameLength_Callback(hObject, eventdata, handles)
% % hObject    handle to editFrameLength (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
% 
% % Hints: get(hObject,'String') returns contents of editFrameLength as text
% %        str2double(get(hObject,'String')) returns contents of editFrameLength as a double
% handles.TimeInst=str2double(get(handles.editFrameLength,'String'));
% 
% % Update handles structure
% guidata(hObject, handles);



% % --- Executes during object creation, after setting all properties.
% function editFrameLength_CreateFcn(hObject, eventdata, handles)
% % hObject    handle to editFrameLength (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    empty - handles not created until after all CreateFcns called
% 
% % Hint: editSamplesSize controls usually have a white background on Windows.
% %       See ISPC and COMPUTER.
% if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
%     set(hObject,'BackgroundColor','white');
% end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-Simulate-%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% --- Executes on button press in SimulateRunBtn.
function SimulateRunBtn_Callback(hObject, eventdata, handles)
% hObject    handle to SimulateRunBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if handles.SamplingVisited==0
    errordlg( 'The signal must be sampled first.','Reconstruction Error.');
else
    if handles.ReconstructVisited==0
        f=errordlg( 'Support recovery failed results may be flawed','Support Recovery Error.');
        uiwait(f);
    end
    
    [handles.RecSignal handles.RecTimeAxis] = RecoverSignal(handles.Signal, handles.MWC, handles.Support, handles.Samples,  handles.TimeAxis, handles);

    tmin = min(handles.RecTimeAxis);
    tmax=  max(handles.RecTimeAxis);
    
    axes(handles.SimulationOriginalaxes);
    temp=handles.SimulationOriginalaxes;
    handles.SimulationOriginalaxes=plot(handles.Nyq_TimeAxis, handles.Sig);
    xlabel('Time (sec)')
    xlim([tmin tmax])
    ylabel('Amplitude');
    handles.SimulationOriginalaxes=temp;

    axes(handles.SimulationReconaxes);
    temp=handles.SimulationReconaxes;
    handles.SimulationReconaxes=plot(handles.RecTimeAxis,handles.RecSignal);
    xlabel('Time (sec)')
    xlim([tmin tmax])
    ylabel('Amplitude');
    handles.SimulationReconaxes=temp;
    
end

if handles.SignalOK==1 && handles.SamplingOK==1 && handles.ReconstructOK==1
    
end
% Update handles structure
guidata(hObject, handles);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Add-Ons%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% --- Executes on button press in radioVCU.
% function radioVCU_Callback(hObject, eventdata, handles)
% % hObject    handle to radioVCU (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
% 
% % Hint: get(hObject,'Value') returns toggle state of radioVCU
% set(hObject,'Value',1.0);
% handles.ReconstructOK=0;
% if handles.Simulated==1
%     showWarningMsg();
%     handles.ReconstructChanged=1;
% end
% handles.frameType=1;
% 
% % Update handles structure
% guidata(hObject, handles);


% % --- Executes on button press in radioQCZ.
% function radioQCZ_Callback(hObject, eventdata, handles)
% % hObject    handle to radioQCZ (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
% 
% % Hint: get(hObject,'Value') returns toggle state of radioQCZ
% set(hObject,'Value',1.0);
% handles.ReconstructOK=0;
% if handles.Simulated==1
%     showWarningMsg();
%     handles.ReconstructChanged=1;
% end
% 
% handles.frameType=2;
% 
% % Update handles structure
% guidata(hObject, handles);


% --------------------------------------------------------------------
function tipHelpMenu_Callback(hObject, eventdata, handles)
% hObject    handle to tipHelpMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
guiGettingStarted=GettingStarted;
movegui(guiGettingStarted,'center')


% --------------------------------------------------------------------
function webHelpMenu_Callback(hObject, eventdata, handles)
% hObject    handle to webHelpMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
web http://webee.technion.ac.il/Sites/People/YoninaEldar/Info/software/GUI/MWC_GUI.htm -browser

function showWarningMsg()
[selectedButton,dlgShown]=uigetpref('Xampling',... % Group
    'ChangeWarning',...           % Preference
    'Warning',...                    % Window title
    {'Warning: The simulation results will be lost'},...
    {'always','never';'Ok','Cancel'});



% --- Executes on button press in SimulateRedrawBtn.
function SimulateRedrawBtn_Callback(hObject, eventdata, handles)
% hObject    handle to SimulateRedrawBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% if handles.SamplingVisited==0
%     errordlg( 'The signal must be sampled first.','Reconstruction Error.');
% elseif handles.ReconstructVisited==0
%     errordlg( 'Support recovery must be performed first','Support Recovery Error.');
% else
%     %%%%% Call Asaf's gui%%%%%
% end
web http://webee.technion.ac.il/Sites/People/YoninaEldar/Info/software/FR/FR.htm -browser


if handles.SignalOK==1 && handles.SamplingOK==1 && handles.ReconstructOK==1
    
end


% % --- Executes on button press in viewCodeBtn.
% function viewCodeBtn_Callback(hObject, eventdata, handles)
% % hObject    handle to viewCodeBtn (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
% 
% if strcmp(get(handles.SignalParamPanel,'Visible'),'on');
%     edit('functionSignal.m');
%     %     uiputfile('functionSignal.m');
% elseif strcmp(get(handles.SampleParamPanel,'Visible'),'on');
%     edit('functionSample.m');
%     %     uiputfile('functionSample.m');
% elseif strcmp(get(handles.FrameReconstructPanel,'Visible'),'on')
%     edit('functionReconstruct.m');
% else
%     edit('functionSimulate.m');
% end


% --- Executes on button press in resetBtn.
function resetBtn_Callback(hObject, eventdata, handles)
% hObject    handle to resetBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
close(handles.Xampling);
guiXampling=Xampling;
movegui(guiXampling,'northwest')


% --- Executes on button press in additionalSettingsBtn.
function additionalSettingsBtn_Callback(hObject, eventdata, handles)
% hObject    handle to additionalSettingsBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
inGUI.N=handles.SigStruct.N;
inGUI.B=handles.SigStruct.B;
inGUI.fmax=handles.SigStruct.fmax;
inGUI.SigStruct=handles.SigStruct;
try
guiAdvancedout = guiAdvanced(inGUI);
handles.SigStruct=guiAdvancedout;
if guiAdvancedout.changed==1
    if handles.SignalOK==1
        resetSignalPlots(hObject, eventdata, handles);
        resetReconPlots(hObject, eventdata, handles);
        set(handles.drawSignalBtn,'Enable','off');
        set(handles.drawRandBtn, 'Enable', 'off');
        handles.SignalOK=0;
        handles.SamplingVisited=0;
        handles.ReconstructVisited=0;
        set(handles.textStilda,'String','[  ]');
        set(handles.textSFailure,'String','???');
        set(handles.textSFailure,'ForegroundColor', [1 1 1]);
        set(handles.textSFailure,'BackgroundColor', [1 0 0]);
    end
end
catch err
end
% handles.SigStruct.N=handles.SigStruct.N;
% handles.SigStruct.B=1e6*handles.B;
% handles.SigStruct.fmax=1e9*handles.fmax;

% Update handles structure
guidata(hObject, handles);


function editNpts_Callback(hObject, eventdata, handles)
% hObject    handle to editNpts (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editNpts as text
%        str2double(get(hObject,'String')) returns contents of editNpts as a double

if handles.SignalOK==1  
axes(handles.TimePlot);
temp=handles.TimePlot;
handles.TimePlot=plot(0,0);
set(handles.TimePlot,'XData',[])
set(handles.TimePlot,'YData',[])
handles.TimePlot=temp;
set(handles.TimePlot,'XTick',[]);
set(handles.TimePlot,'YTick',[]);


axes(handles.FreqPlot);
temp=handles.FreqPlot;
handles.FreqPlot=plot(0,0);
set(handles.FreqPlot,'XData',[])
set(handles.FreqPlot,'YData',[])
handles.FreqPlot=temp;
set(handles.FreqPlot,'XTick',[]);
set(handles.FreqPlot,'YTick',[]);
end


% --- Executes during object creation, after setting all properties.
function editNpts_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editNpts (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: editSamplesSize controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%%%%
%% function ClearBar(handles)
%%%%

%%%%
%% function CleanBar(handles)
%%%%


%%%%
%function updateProgBar(k,handles,N)%
%%%%



function editAltSpeed_Callback(hObject, eventdata, handles)
% hObject    handle to editAltSpeed (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editAltSpeed as text
%        str2double(get(hObject,'String')) returns contents of editAltSpeed as a double
handles.MWC.Speed = 1e9*str2num(get(handles.editAltSpeed,'String'));
% set(handles.textInvTp,'String',['1/Tp = ' num2str(round(100*1e-6*handles.MWC.Speed/handles.MWC.M)/100) ' MHz']);
% set(handles.textTp,'String',['Tp = ' num2str(round(100*1e9*handles.MWC.M/handles.MWC.Speed)/100) ' nanosec']);
% The round(100*.....)/100 makes sure only 2 digits are displayed after the
% decimal point

if 1/handles.MWC.Ts <= handles.MWC.Speed/handles.MWC.M %  if 1/Ts <= 1/Tp
    set(handles.editAltSpeed,'ForegroundColor',[1 0 0]); % Change color to red
else
    set(handles.editFs,'ForegroundColor',[0 0 0]);
    set(handles.editAltSpeed,'ForegroundColor',[0 0 0]);
    set(handles.editSigAlt,'ForegroundColor',[0 0 0]);
end

% Since Data was changed a new validity check is necessary
if handles.SamplingVisited==1
    resetReconPlots(hObject, eventdata, handles);
    set(handles.drawRandBtn, 'Enable', 'off');
    handles.SamplingVisited=0;
    handles.ReconstructVisited=0;
    set(handles.textStilda,'String','[  ]');
    set(handles.textSFailure,'String','???');
    set(handles.textSFailure,'ForegroundColor', [1 1 1]);
    set(handles.textSFailure,'BackgroundColor', [1 0 0]);
end

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editAltSpeed_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editAltSpeed (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: editSamplesSize controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editSigns_Callback(hObject, eventdata, handles)
% hObject    handle to editSigns (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editSigns as text
%        str2double(get(hObject,'String')) returns contents of editSigns as a double


% --- Executes during object creation, after setting all properties.
function editSigns_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editSigns (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: editSamplesSize controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editSigAlt_Callback(hObject, eventdata, handles)
% hObject    handle to editSigAlt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editSigAlt as text
%        str2double(get(hObject,'String')) returns contents of editSigAlt as a double
handles.MWC.M = str2num(get(handles.editSigAlt,'String'));
% set(handles.textInvTp,'String',['1/Tp = ' num2str(round(100*1e-6*handles.MWC.Speed/handles.MWC.M)/100) ' MHz']);
% set(handles.textTp,'String',['Tp = ' num2str(round(100*1e9*handles.MWC.M/handles.MWC.Speed)/100) ' nanosec']);
% The round(100*.....)/100 makes sure only 2 digits are displayed after the
% decimal point

fp = 2*handles.SigStruct.fmax / handles.MWC.M ;
handles.MWC.Ts = 1/fp;
handles.MWC.fcut = fp/2;
set(handles.editFs,'String',num2str(fp/1e6));
set(handles.editCutoff,'String',num2str(handles.MWC.fcut/1e6));
set(handles.textTotalSampling,'String',num2str((1e-6/handles.MWC.Ts)*handles.MWC.m));
set(handles.textNyq,'String',num2str(2*1000*handles.SigStruct.fmax/1e9));
set(handles.drawRandBtn, 'Enable', 'off');


% if 1/handles.MWC.Ts <= handles.MWC.Speed/handles.MWC.M %  if 1/Ts <= 1/Tp
%     set(handles.editSigAlt,'ForegroundColor',[1 0 0]); % Change color to red
% else
%     set(handles.editFs,'ForegroundColor',[0 0 0]);
%     set(handles.editAltSpeed,'ForegroundColor',[0 0 0]);
%     set(handles.editSigAlt,'ForegroundColor',[0 0 0]);
% end

% Since Data was changed a new validity check is necessary
if handles.SamplingVisited==1
    resetReconPlots(hObject, eventdata, handles);
    set(handles.drawRandBtn, 'Enable', 'off');
    handles.SamplingVisited=0;
    handles.ReconstructVisited=0;
    set(handles.textStilda,'String','[  ]');
    set(handles.textSFailure,'String','???');
    set(handles.textSFailure,'ForegroundColor', [1 1 1]);
    set(handles.textSFailure,'BackgroundColor', [1 0 0]);
end

% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function editSigAlt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editSigAlt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: editSamplesSize controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function editFs_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editFs (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: editSamplesSize controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in loadFromWorkspaceBtn.
function loadFromWorkspace(hObject, eventdata, handles)
% hObject    handle to loadFromWorkspaceBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
signsString=get(handles.editSigns,'String');
try
    signs=evalin('base',signsString);
    if(exist('signs','var'));
        if size(signs,1) ==handles.MWC.m && size(signs,2) ==handles.MWC.M && sum(sum(signs<-1 |  signs>1))==0
            handles.MWC = setfield(handles.MWC, 'SignPatterns',signs);
            set(handles.editSigns,'ForegroundColor',[0 0 0]);
            handles.SamplingOK=1;
        else
            set(handles.editSigns,'ForegroundColor',[1 0 0]); % Change color to red
            handles.SamplingOK=0;
        end
    else
        set(handles.editSigns,'ForegroundColor',[1 0 0]); % Change color to red
        handles.SamplingOK=0;
    end
    
catch err
    if strcmp(err.identifier, 'MATLAB:UndefinedFunction')
        set(handles.editSigns,'ForegroundColor',[1 0 0]); % Change color to red
        handles.SamplingOK=0;
    end
end

% Since Data was changed a new validity check is necessary
if handles.SamplingVisited==1
    resetReconPlots(hObject, eventdata, handles);
    set(handles.drawRandBtn, 'Enable', 'off');
    handles.SamplingVisited=0;
    handles.ReconstructVisited=0;
    set(handles.textStilda,'String','[  ]');
    set(handles.textSFailure,'String','???');
    set(handles.textSFailure,'ForegroundColor', [1 1 1]);
    set(handles.textSFailure,'BackgroundColor', [1 0 0]);
end

% Update handles structure
guidata(hObject, handles);


% --- Executes on button press in drawRandBtn.
function drawRandBtn_Callback(hObject, eventdata, handles)
% hObject    handle to drawRandBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.MWC = setfield(handles.MWC, 'SignPatterns', RandSource(handles.MWC.m,handles.MWC.M));
%handles.SamplingOK=1;  % no need anymore
% Update handles structure
guidata(hObject, handles);

% --- Executes on button press in generateSampleBtn.
function generateSampleBtn_Callback(hObject, eventdata, handles)
% hObject    handle to generateSampleBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Load sign patterns or draw them if needed
if get(handles.radioRandomSigns,'Value')==1.0   % draw random
    if (strmatch(get(handles.drawRandBtn, 'Enable'), 'off'))
        handles.MWC = setfield(handles.MWC, 'SignPatterns', RandSource(handles.MWC.m,handles.MWC.M));
        set(handles.drawRandBtn, 'Enable', 'on');
    end
else
    loadFromWorkspace(hObject, eventdata, handles)
end

% Now we generate the signal structure
if handles.SignalOK==0  
    % OMRI: here we need to check that N is even + NB<fmax. we return error if not.
    %     handles.SigStruct.N=handles.N;
    %     handles.SigStruct.B=1e6*handles.B;
    %     handles.SigStruct.fmax=1e9*handles.fmax;
    handles.Signal = GenerateSignal(handles.SigStruct);
end
handles.SignalOK=1;



% OMRI: here we need to check that N is even + NB<fmax. we return error if not.
%if handles.SignalOK ==1 
    %if handles.SamplingOK==1
    if sum(get(handles.editFs,'ForegroundColor'),2) ==0 && sum(get(handles.editAltSpeed,'ForegroundColor'),2) ==0 && sum(get(handles.editSigAlt,'ForegroundColor'),2) ==0
        CleanBar(handles);
        ShowBar(handles);
        set(handles.uneditStatus,'String','Status: Busy, Mixing and Filtering');
        [handles.Samples, handles.TimeAxis, handles.A, handles.Sig, handles.Nyq_TimeAxis] = MWC_SubNyquistSample(handles.Signal,handles.MWC,handles);
        set(handles.drawSignalBtn,'Enable','on')
        handles.SamplingVisited=1;
        ClearBar(handles);
        set(handles.uneditProgPrecent,'String','');
        set(handles.uneditStatus,'String','Status: Ready (waiting for user input)');
        set(handles.drawRandBtn,'Enable','on');
        %   else
        %       errordlg( 'Make sure 1/Ts > 1/Tp ','Sampling Error.');
        %   end
    else
        errordlg( 'Make sure sign patterns were drawn or loaded from workspace','Sampling Error.');
    end
%else
%    errordlg( 'The signal must be drawn first.','Signal Error.');
%end
% Update handles structure
guidata(hObject, handles);




% --- Executes during object creation, after setting all properties.
function text123_CreateFcn(hObject, eventdata, handles)
% hObject    handle to text123 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called



function editFs_Callback(hObject, eventdata, handles)
% hObject    handle to editFs (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editFs as text
%        str2double(get(hObject,'String')) returns contents of editFs as a double
handles.MWC.Ts=1e-6/str2double(get(handles.editFs,'String'));
set(handles.textTotalSampling,'String',num2str((1e-6/handles.MWC.Ts)*handles.MWC.m));
if 1/handles.MWC.Ts <= handles.MWC.Speed/handles.MWC.M %  if 1/Ts <= 1/Tp
    set(handles.editFs,'ForegroundColor',[1 0 0]); % Change color to red
else
    set(handles.editFs,'ForegroundColor',[0 0 0]);
    set(handles.editAltSpeed,'ForegroundColor',[0 0 0]);
    set(handles.editSigAlt,'ForegroundColor',[0 0 0]);
end

% Update handles structure
guidata(hObject, handles);


% --- Executes on button press in runRecoveryBtn.
function runRecoveryBtn_Callback(hObject, eventdata, handles)
% hObject    handle to runRecoveryBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if handles.SamplingVisited==1
    CleanBar(handles);
    ShowBar(handles);
    set(handles.uneditStatus,'String','Status: Busy, expanding');
    updateProgBar(25,handles,100);
    %    [ handles.Support,  handles.ExSamples, handles.ExTimeAxis Success] = RecoverSupport( handles.Signal, handles.MWC,  handles.Samples,  handles.TimeAxis, handles);
    [ handles.Support, Success] = RecoverSupport( handles.Signal, handles.MWC,  handles.Samples,  handles.TimeAxis, handles);
    updateProgBar(100,handles,200);
    ClearBar(handles);
    set(handles.uneditProgPrecent,'String','');
    set(handles.uneditStatus,'String','Status: Ready (waiting for user input)');
    if Success
        set(handles.textStilda,'String',['[ ' num2str(handles.Support) ' ]']);
        set(handles.textSFailure,'String','Success');
        set(handles.textSFailure,'ForegroundColor', [0 0 0]);
        set(handles.textSFailure,'BackgroundColor', [1 1 0]);
        handles.ReconstructVisited=1;        
    else
        % Failure:
        set(handles.textStilda,'String',['[ ' num2str(handles.Support) ' ]']);
        set(handles.textSFailure,'String','Failure');
        set(handles.textSFailure,'ForegroundColor', [1 1 1]);
        set(handles.textSFailure,'BackgroundColor', [1 0 0]);
    end
else
    errordlg( 'The signal must be sampled first.','Support Recovery Error.');
end
% Update handles structure
guidata(hObject, handles);


function editSamplesSize_Callback(hObject, eventdata, handles)
% hObject    handle to editSamplesSize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editSamplesSize as text
%        str2double(get(hObject,'String')) returns contents of editSamplesSize as a double
% Since Data was changed a new validity check is necessary
% Since Data was changed a new validity check is necessary
if handles.SamplingVisited==1
    resetReconPlots(hObject, eventdata, handles);
    set(handles.drawRandBtn, 'Enable', 'off');
    handles.SamplingVisited=0;
    handles.ReconstructVisited=0;
    set(handles.textStilda,'String','[  ]');
    set(handles.textSFailure,'String','???');
    set(handles.textSFailure,'ForegroundColor', [1 1 1]);
    set(handles.textSFailure,'BackgroundColor', [1 0 0]);
end


% --- Executes during object creation, after setting all properties.
function editSamplesSize_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editSamplesSize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: editSamplesSize controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% % --- Executes when selected object is changed in CSReconstructPanel.
% function CSReconstructPanel_SelectionChangeFcn(hObject, eventdata, handles)
% % hObject    handle to the selected object in CSReconstructPanel
% % eventdata  structure with the following fields (see UIBUTTONGROUP)
% %	EventName: string 'SelectionChanged' (read only)
% %	OldValue: handle of the previously selected object or empty if none was selected
% %	NewValue: handle of the currently selected object
% % handles    structure with handles and user data (see GUIDATA)



% --- Executes on button press in drawSignalBtn.
function drawSignalBtn_Callback(hObject, eventdata, handles)
% hObject    handle to drawSignalBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.Signal = GenerateSignal(handles.SigStruct);
handles.SignalOK=1;
resetSignalPlots(hObject, eventdata, handles);
resetReconPlots(hObject, eventdata, handles);
set(handles.drawSignalBtn,'Enable','off');
set(handles.drawRandBtn, 'Enable', 'off');
handles.SamplingVisited=0;
handles.ReconstructVisited=0;
set(handles.textStilda,'String','[  ]');
set(handles.textSFailure,'String','???');
set(handles.textSFailure,'ForegroundColor', [1 1 1]);
set(handles.textSFailure,'BackgroundColor', [1 0 0]);
% Update handles structure
guidata(hObject, handles);


% --------------------------------------------------------------------
function loadMenu_Callback(hObject, eventdata, handles)
% hObject    handle to loadMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[filename, pathname] = uigetfile( '*.mat','MAT-files (*.mat)');
loadedPath = fullfile(pathname,filename);
if loadedPath(end)~='\'
    load(loadedPath);
    resetSignalPlots(hObject, eventdata, handles);
    resetReconPlots(hObject, eventdata, handles);
    set(handles.editNpts,'String',num2str(Npts));
    set(handles.editSigns,'String',signsString);
    set(handles.editNumSamples,'String',num2str(numSamples));
    if isPSD==1
        set(handles.radioPSD,'Value',1.0);
        set(handles.radioFFT,'Value',0.0);
    else
        set(handles.radioPSD,'Value',0.0);
        set(handles.radioFFT,'Value',1.0);
    end
    
    if exist('SigStruct')
        handles.SigStruct=SigStruct;
        set(handles.editN,'String',num2str(handles.SigStruct.N));
        set(handles.editB,'String',num2str(handles.SigStruct.B*1e-6));
        set(handles.editFmax,'String',num2str(handles.SigStruct.fmax*1e-9));
        handles.SignalOK =0;
        handles.SamplingOK=0;
    end
    if exist('MWC')
        handles.MWC=MWC;
        set(handles.editM,'String',num2str(handles.MWC.m));
        set(handles.editFs,'String',num2str(1e-6/handles.MWC.Ts));
        set(handles.editAltSpeed,'String',num2str(handles.MWC.M));
        set(handles.editCutoff,'String',num2str(1e-6*handles.MWC.fcut));
        set(handles.editAltSpeed,'String',num2str(1e-9*handles.MWC.Speed));
        
        set(handles.textTotalSampling,'String',num2str((1e-6/handles.MWC.Ts)*handles.MWC.m));
        set(handles.textNyq,'String',num2str(2*1000*handles.SigStruct.fmax/1e9));
        %             set(handles.textInvTp,'String',['1/Tp = ' num2str(round(100*1e-6*handles.MWC.Speed/handles.MWC.M)/100) ' MHz']);
        %             set(handles.textTp,'String',['Tp = ' num2str(round(100*1e9*handles.MWC.M/handles.MWC.Speed)/100) ' nanosec']);
        
        set(handles.editFs,'ForegroundColor',[0 0 0]);
        set(handles.editAltSpeed,'ForegroundColor',[0 0 0]);
        set(handles.editSigAlt,'ForegroundColor',[0 0 0]);
        handles.SamplingVisited=0;
    end
    if exist('Signal')
        handles.Signal=Signal;
        handles.SignalOK=1;
    end
    if exist('Samples')
        handles.Signal=Samples;
        handles.SamplingVisited=1;
    end
    
end

% Since Data was changed a new validity check is necessary
if handles.SignalOK==1
    resetSignalPlots(hObject, eventdata, handles);
    resetReconPlots(hObject, eventdata, handles);
    set(handles.drawSignalBtn,'Enable','off');
    set(handles.drawRandBtn, 'Enable', 'off');
    handles.SignalOK=0;
    handles.SamplingVisited=0;
    handles.ReconstructVisited=0;
    set(handles.textStilda,'String','[  ]');
    set(handles.textSFailure,'String','???');
    set(handles.textSFailure,'ForegroundColor', [1 1 1]);
    set(handles.textSFailure,'BackgroundColor', [1 0 0]);
end

% Update handles structure
guidata(hObject, handles);

% --------------------------------------------------------------------
function saveMenu_Callback(hObject, eventdata, handles)
% hObject    handle to saveMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[filename, pathname] = uiputfile( '*.mat','MAT-files (*.mat)','Data.mat');
savedPath = fullfile(pathname,filename);
Npts=str2num(get(handles.editNpts,'String'));
signsString=get(handles.editSigns,'String');
numSamples=get(handles.editNumSamples,'String');
isPSD=get(handles.radioPSD,'Value');


if isfield(handles,'SigStruct') && isfield(handles,'Signal') && isfield(handles,'MWC') && isfield(handles,'Samples')
    SigStruct=handles.SigStruct;
    Signal=handles.Signal;
    MWC=handles.MWC;
    Samples=handles.Samples;
    save(savedPath,'SigStruct','MWC','Signal','Npts','signsString','numSamples','isPSD','Samples');
elseif isfield(handles,'SigStruct') && isfield(handles,'Signal') && isfield(handles,'MWC') && ~isfield(handles,'Samples')
    SigStruct=handles.SigStruct;
    Signal=handles.Signal;
    MWC=handles.MWC;
    save(savedPath,'SigStruct','MWC','Signal','Npts','signsString','numSamples','isPSD');
elseif isfield(handles,'SigStruct') && ~isfield(handles,'Signal')
    SigStruct=handles.SigStruct;
    save(savedPath,'SigStruct','Npts','signsString','numSamples','isPSD');
elseif isfield(handles,'SigStruct') && isfield(handles,'Signal') &&  ~isfield(handles,'MWC')
    SigStruct=handles.SigStruct;
    Signal=handles.Signal;
    save(savedPath,'SigStruct','Signal','Npts','signsString','numSamples','isPSD');
elseif isfield(handles,'SigStruct') && ~isfield(handles,'Signal') && isfield(handles,'MWC')
    SigStruct=handles.SigStruct;
    MWC=handles.MWC;
    save(savedPath,'SigStruct','MWC','Npts','signsString','numSamples','isPSD');
else
    save(savedPath,'Npts','signsString','numSamples','isPSD');
end



% --------------------------------------------------------------------
function reportProblemMenu_Callback(hObject, eventdata, handles)
% hObject    handle to reportProblemMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
web mailto:'moshiko@tx.technion.ac.il,yonina@ee.technion.ac.il'



function editNumSamples_Callback(hObject, eventdata, handles)
% hObject    handle to editNumSamples (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editNumSamples as text
%        str2double(get(hObject,'String')) returns contents of editNumSamples as a double
% Since Data was changed a new validity check is necessary
if handles.SamplingVisited==1
    resetReconPlots(hObject, eventdata, handles);
    set(handles.drawRandBtn, 'Enable', 'off');
    handles.SamplingVisited=0;
    handles.ReconstructVisited=0;
    set(handles.textStilda,'String','[  ]');
    set(handles.textSFailure,'String','???');
    set(handles.textSFailure,'ForegroundColor', [1 1 1]);
    set(handles.textSFailure,'BackgroundColor', [1 0 0]);
end


% --- Executes during object creation, after setting all properties.
function editNumSamples_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editNumSamples (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes when selected object is changed in uipanelPSDFFT.
function uipanelPSDFFT_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in uipanelPSDFFT 
% eventdata  structure with the following fields (see UIBUTTONGROUP)
%	EventName: string 'SelectionChanged' (read only)
%	OldValue: handle of the previously selected object or empty if none was selected
%	NewValue: handle of the currently selected object
% handles    structure with handles and user data (see GUIDATA)
if handles.SignalOK==1  
axes(handles.FreqPlot);
temp=handles.FreqPlot;
handles.FreqPlot=plot(0,0);
set(handles.FreqPlot,'XData',[])
set(handles.FreqPlot,'YData',[])
handles.FreqPlot=temp;
set(handles.FreqPlot,'XTick',[]);
set(handles.FreqPlot,'YTick',[]);
end

function resetSignalPlots(hObject, eventdata, handles)
if handles.SignalOK==1
    axes(handles.TimePlot);
    temp=handles.TimePlot;
    handles.TimePlot=plot(0,0);
    set(handles.TimePlot,'XData',[])
    set(handles.TimePlot,'YData',[])
    handles.TimePlot=temp;
    set(handles.TimePlot,'XTick',[]);
    set(handles.TimePlot,'YTick',[]);
    
    
    axes(handles.FreqPlot);
    temp=handles.FreqPlot;
    handles.FreqPlot=plot(0,0);
    set(handles.FreqPlot,'XData',[])
    set(handles.FreqPlot,'YData',[])
    handles.FreqPlot=temp;
    set(handles.FreqPlot,'XTick',[]);
    set(handles.FreqPlot,'YTick',[]);
end

function resetReconPlots(hObject, eventdata, handles)
    axes(handles.SimulationOriginalaxes);
    temp=handles.SimulationOriginalaxes;
    handles.SimulationOriginalaxes=plot(0,0);
    set(handles.SimulationOriginalaxes,'XData',[])
    set(handles.SimulationOriginalaxes,'YData',[])
    handles.SimulationOriginalaxes=temp;
    set(handles.SimulationOriginalaxes,'XTick',[]);
    set(handles.SimulationOriginalaxes,'YTick',[]);
    
    
    axes(handles.SimulationReconaxes);
    temp=handles.SimulationReconaxes;
    handles.SimulationReconaxes=plot(0,0);
    set(handles.SimulationReconaxes,'XData',[])
    set(handles.SimulationReconaxes,'YData',[])
    handles.SimulationReconaxes=temp;
    set(handles.SimulationReconaxes,'XTick',[]);
    set(handles.SimulationReconaxes,'YTick',[]);


% --- Executes on button press in zoomoutBtn.
function zoomoutBtn_Callback(hObject, eventdata, handles)
% hObject    handle to zoomoutBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if get(handles.zoomoutBtn,'Value') ==1 
    h=zoom;
    set(h,'Direction','out')
    set(h,'Enable','on')
    set(handles.zoominBtn,'Value',0);
    set(handles.zoomoutBtn,'Value',1);
else
    zoom off
    set(handles.zoomoutBtn,'Value',0);
end

% Update handles structure
guidata(hObject, handles);



% --- Executes on button press in zoominBtn.
function zoominBtn_Callback(hObject, eventdata, handles)
% hObject    handle to zoominBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if get(handles.zoominBtn,'Value') ==1 
    h=zoom;
    set(h,'Direction','in')
    set(h,'Enable','on')
    set(handles.zoominBtn,'Value',1);
    set(handles.zoomoutBtn,'Value',0);
else
    zoom off
    set(handles.zoominBtn,'Value',0);
end
% Update handles structure
guidata(hObject, handles);


% --- Executes on button press in simulationZoomoutBtn.
function simulationZoomoutBtn_Callback(hObject, eventdata, handles)
% hObject    handle to simulationZoomoutBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if get(handles.simulationZoomoutBtn,'Value') ==1 
    h=zoom;
    set(h,'Direction','out')
    set(h,'Enable','on')
    set(handles.simulationZoominBtn,'Value',0);
    set(handles.simulationZoomoutBtn,'Value',1);
else
    zoom off
    set(handles.simulationZoomoutBtn,'Value',0);
end
% Update handles structure
guidata(hObject, handles);


% --- Executes on button press in simulationZoominBtn.
function simulationZoominBtn_Callback(hObject, eventdata, handles)
% hObject    handle to simulationZoominBtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if get(handles.simulationZoominBtn,'Value') ==1 
    h=zoom;
    set(h,'Direction','in')
    set(h,'Enable','on')
    set(handles.simulationZoomoutBtn,'Value',0);
    set(handles.simulationZoominBtn,'Value',1);
else
    zoom off
    set(handles.simulationZoominBtn,'Value',0);
end
% Update handles structure
guidata(hObject, handles);
