% This function set all the parameters of the MWC automatially, based on a
% given model parameters N,B,fmax

function MWCStruct = Auto_Set_MWC(N,B,fmax)
MWCStruct = ConstructDefaultMWCstruct();

m = ceil(4*N*40/24);
fnyq = 2*fmax;
M = ceil(fnyq/B);
if mod(M,2)==0
    M=M+1;
end
fp = fnyq/M;


MWCStruct = setfield(MWCStruct, 'm', m); 
MWCStruct = setfield(MWCStruct, 'fcut', fp/2);   % filter cutoff
MWCStruct = setfield(MWCStruct, 'Ts', 1/fp);   % sampling rate per channel

% periodic waveforms
fnyq = 2*fmax;
MWCStruct = setfield(MWCStruct, 'Speed', fnyq);
fp = B / 0.975;  % we take fp slightly bigger than B to avoid edge effects
MWCStruct = setfield(MWCStruct, 'M', M);  % number of alternations
MWCStruct = setfield(MWCStruct, 'SignPatterns', RandSource(MWCStruct.m,MWCStruct.M));
