% This function calculates the original support of the Signal

function S = CalculateSupport(Signal,MWC)
% get relevant parameters
N = getfield(Signal.Structure, 'N');
B = getfield(Signal.Structure, 'B');
fmax = getfield(Signal.Structure, 'fmax');
Carriers = getfield(Signal.Values, 'Carriers');
fnyq = 2*fmax;
AltSpeed = getfield(MWC, 'Speed');
M = getfield(MWC, 'M');
m = getfield(MWC, 'm');
fp = AltSpeed/M;
L = ceil(fnyq/fp);
if mod(L,2)==0
    L=L+1;
end   % L is the number of specturm slices, namely the length of z[n]
L0 = (L-1)/2;

% Calculate original support set
S = [];
% explain:  we take the starting edges: fi-B/2  and divide by fp. minus
% 0.5 to shift half fp towards zero. then L0+1 is to move 0 = L0+1.
if (strmatch(Signal.Structure.Type, 'sinc'))
    Beff = B;
elseif (strmatch(Signal.Structure.Type, 'bpsk'))
    Beff = 1/Signal.Structure.BPSK_Tsymbol;
elseif (strmatch(Signal.Structure.Type, 'qpsk'))
    Beff = 1/Signal.Structure.QPSK_Tsymbol;
end

Starts = ceil(  (Carriers-Beff/2)/fp-0.5+L0+1);
Ends = ceil( (Carriers+Beff/2)/fp-0.5+L0+1);
for i=1:(N/2)
    S = union (S,  Starts(i):Ends(i));
end
% Now add the negative frequencies
S = union(S, L+1-S);
S = sort(S);
