function PlotSignal_Freq(SignalAmp, NoiseAmp, TimeAxis, FigHandle)
if nargin>4
    figure(FigHandle);
else
    figure;
end
Sig = SignalAmp + NoiseAmp;


dt = TimeAxis(2)-TimeAxis(1);
fs = 1/dt;
f_axis = linspace(-fs/2,fs/2,length(TimeAxis));
Fsig = fftshift((fft(Sig)));
plot(f_axis,20*log10(abs(Fsig)));
axis tight;
xlabel('Frequency (Hz)')
ylabel('Amplitude (dB)')

