% This function reconstruct the signal from the recovered support and the
% samples
function [RecSignal RecTimeAxis] = RecoverSignal(Signal,MWC,Support,Samples,TimeAxis,handles)


[m,NumSamples] = size(Samples);
A = handles.A;
[m,M] = size(A);
Zn = zeros(M,NumSamples);
As = A(:,Support);
Zn(Support,:) = pinv(As)*Samples;

Ts = TimeAxis(2)-TimeAxis(1);
T = Ts/M;
L0=(M-1)/2;
RecTimeAxis = linspace(   (min(TimeAxis)-L0*T),  (max(TimeAxis)+L0*T),  M*NumSamples );

RecSignal=zeros(size(RecTimeAxis));

CleanBar(handles);
ShowBar(handles);
set(handles.uneditStatus,'String','Status: Busy, Recovering signal');

for Zind = 1:L0
    Zn_int = interpft(Zn(Zind,:),M*NumSamples);
    slice = Zind - L0 -1;
    Mod = exp(j*2*pi*slice/M*RecTimeAxis/T);
    RecSignal = RecSignal + 2*real(Zn_int.*Mod);
    updateProgBar(Zind,handles,(L0+1)*2);    
end
Z0_int = interpft(Zn(L0+1,:),M*NumSamples);
updateProgBar(L0+1,handles,(L0+1)*2);
RecSignal = RecSignal + Z0_int;
ClearBar(handles);
set(handles.uneditProgPrecent,'String','');
set(handles.uneditStatus,'String','Status: Ready (waiting for user input)');
