function varargout = guiAdvanced(varargin)
% GUIADVANCED M-file for guiAdvanced.fig
%      GUIADVANCED, by itself, creates a new GUIADVANCED or raises the existing
%      singleton*.
%
%      H = GUIADVANCED returns the handle to a new GUIADVANCED or the handle to
%      the existing singleton*.
%
%      GUIADVANCED('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in GUIADVANCED.M with the given input arguments.
%
%      GUIADVANCED('Property','Value',...) creates a new GUIADVANCED or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before guiAdvanced_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to guiAdvanced_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help guiAdvanced

% Last Modified by GUIDE v2.5 16-Nov-2009 18:25:31

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @guiAdvanced_OpeningFcn, ...
                   'gui_OutputFcn',  @guiAdvanced_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before guiAdvanced is made visible.
function guiAdvanced_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to guiAdvanced (see VARARGIN)

% Choose default command line output for guiAdvanced
turn2gray=struct2cell(handles);
for k=1:size(turn2gray,1)    
    if isfield(get(turn2gray{k}), 'BackgroundColor')
        if isfield(get(turn2gray{k}),'Style') && ~strcmp(get(turn2gray{k},'Style'),'edit')
        set(turn2gray{k}, 'BackgroundColor', [0.831373 0.815686 0.784314]);
        elseif ~isfield(get(turn2gray{k}),'Style')
            set(turn2gray{k}, 'BackgroundColor', [0.831373 0.815686 0.784314]);
        end
    end
        if isfield(get(turn2gray{k}), 'Color')
            set(turn2gray{k}, 'Color', [0.831373 0.815686 0.784314]);
        end
end

handles.output = hObject;
handles.N=varargin{1}.N;
handles.B = varargin{1}.B;
handles.fmax = varargin{1}.fmax;
handles.SigStruct= varargin{1}.SigStruct;
if strcmp(handles.SigStruct.Type,'sinc')
    set(handles.editSigDur,'String',num2str(handles.SigStruct.SincDuration));
    set(handles.radioSinc,'Value',1.0);
    set(handles.radioQPSK,'Value',0.0);
    set(handles.radioBPSK,'Value',0.0);
    
    if strcmp(handles.SigStruct.SincEnergies,'random')
        set(handles.radioSigEnergyRand,'Value',1.0);
        set(handles.radioSigEnergySpec,'Value',0.0);
        set(handles.editSigEnergy,'Enable','off');
    elseif strcmp(handles.SigStruct.SincEnergies,'specify')
        set(handles.editSigEnergy,'String',handles.SigStruct.SincEnergiesString);
        set(handles.radioSigEnergySpec,'Value',1.0);
        set(handles.radioSigEnergyRand,'Value',0.0);
        set(handles.editSigEnergy,'Enable','on');
    end
    if strcmp(handles.SigStruct.SincDelays, 'random')
        set(handles.radioSigDelayRand,'Value',1.0);
        set(handles.radioSigDelaySpec,'Value',0.0);
        set(handles.editSigDelay,'Enable','off');
    elseif strcmp(handles.SigStruct.SincDelays, 'specify')
        set(handles.radioSigDelaySpec,'Value',1.0);
        set(handles.radioSigDelayRand,'Value',0.0);
        set(handles.editSigDelay,'Enable','on');
        set(handles.editSigDelay,'String',handles.SigStruct.SincDelaysString);
    end
elseif strcmp(handles.SigStruct.Type,'bpsk')
    set(handles.radioBPSK,'Value',1.0);
    set(handles.radioSinc,'Value',0.0);
    set(handles.radioQPSK,'Value',0.0);
    set(handles.editSymDur,'String',num2str(handles.SigStruct.BPSK_Tsymbol));
    set(handles.editNumSym,'String',num2str(handles.SigStruct.BPSK_NumSymbols));
    
    if strcmp(handles.SigStruct.BPSKEnergies,'random')
        set(handles.radioSymEnergyRand,'Value',1.0);
        set(handles.radioSymEnergySpec,'Value',0.0);
        set(handles.editSymEnergy,'Enable','off');
    elseif strcmp(handles.SigStruct.BPSKEnergies,'specify')
        set(handles.radioSymEnergySpec,'Value',1.0);
        set(handles.radioSymEnergyRand,'Value',0.0);
        set(handles.editSymEnergy,'Enable','on');
        set(handles.editSymEnergy,'String',handles.SigStruct.BPSKEnergiesString);
    end
    
    if strcmp(handles.SigStruct.BPSK_pulseshape,'sinc')
        set(handles.radioSymShapeRand,'Value',1.0);
        set(handles.radioSymShapeCos,'Value',0.0);
        set(handles.editShapeCosine,'Enable','off');
        set(handles.slider1,'Enable','off');
    else
        set(handles.radioSymShapeCos,'Value',1.0);
        set(handles.radioSymShapeRand,'Value',0.0);
        set(handles.editShapeCosine,'Enable','on');
        set(handles.slider1,'Enable','on');
        set(handles.editShapeCosine,'String',num2str(handles.SigStruct.BPSK_pulseshape_rolloff));
    end
    
    
elseif strcmp(handles.SigStruct.Type,'qpsk')
    set(handles.radioQPSK,'Value',1.0);
    set(handles.radioSinc,'Value',0.0);
    set(handles.radioBPSK,'Value',0.0);
    set(handles.editSymDur,'String',num2str(handles.SigStruct.QPSK_Tsymbol));
    set(handles.editNumSym,'String',num2str(handles.SigStruct.QPSK_NumSymbols));
    
    if strcmp(handles.SigStruct.QPSKEnergies,'random')
        set(handles.radioSymEnergyRand,'Value',1.0);
        set(handles.radioSymEnergySpec,'Value',0.0);
        set(handles.editSymEnergy,'Enable','off');
    elseif strcmp(handles.SigStruct.QPSKEnergies,'specify')
        set(handles.radioSymEnergySpec,'Value',1.0);
        set(handles.radioSymEnergyRand,'Value',0.0);
        set(handles.editSymEnergy,'Enable','on');
        set(handles.editSymEnergy,'String',handles.SigStruct.QPSKEnergiesString);
    end
    
    if strcmp(handles.SigStruct.QPSK_pulseshape,'sinc')
        set(handles.radioSymShapeRand,'Value',1.0);
        set(handles.radioSymShapeCos,'Value',0.0);
        set(handles.editShapeCosine,'Enable','off');
        set(handles.slider1,'Enable','off');
    else
        set(handles.radioSymShapeCos,'Value',1.0);
        set(handles.radioSymShapeRand,'Value',0.0);
        set(handles.editShapeCosine,'Enable','on');
        set(handles.slider1,'Enable','on');
        set(handles.editShapeCosine,'String',num2str(handles.SigStruct.QPSK_pulseshape_rolloff));
    end
end

if strcmp(handles.SigStruct.Carriers,'random')
    set(handles.radioCarrierRand,'Value',1.0);
    set(handles.radioCarrierSpec,'Value',0.0);
    set(handles.editCarrier,'Enable','off');
elseif  strcmp(handles.SigStruct.Carriers,'specify')
    set(handles.editCarrier,'String',handles.SigStruct.CarriersString);
    set(handles.radioCarrierSpec,'Value',1.0);
    set(handles.radioCarrierRand,'Value',0.0);
    set(handles.editCarrier,'Enable','on');
end

    set(handles.editSNR,'String',num2str(handles.SigStruct.SNR));
    
handles.changed=0;
handles.OutputFlag=0;

imageArray =imread('SincEq.bmp');
% Switch active axes to the one you made for the image.
axes(handles.axesSincPic);
% Put the image array into the axes so it will appear on the GUI
imshow(imageArray);

imageArray =imread('PSKEq.bmp');
% Switch active axes to the one you made for the image.
axes(handles.axesPSKPic);
% Put the image array into the axes so it will appear on the GUI
imshow(imageArray);


% Update handles structure
guidata(hObject, handles);

% UIWAIT makes guiAdvanced wait for user response (see UIRESUME)
uiwait(handles.figAdvanced);


% --- Outputs from this function are returned to the command line.
function varargout = guiAdvanced_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;
delete(handles.figAdvanced);


% --- Executes on button press in radioBPSK.
function radioBPSK_Callback(hObject, eventdata, handles)
% hObject    handle to radioBPSK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radioBPSK
set(handles.radioSinc,'Value',0.0);
set(handles.radioBPSK,'Value',1.0);
set(handles.radioQPSK,'Value',0.0);
handles.changed=1;
% Update handles structure
guidata(hObject, handles);


% --- Executes on button press in radioQPSK.
function radioQPSK_Callback(hObject, eventdata, handles)
% hObject    handle to radioQPSK (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radioQPSK   
set(handles.radioSinc,'Value',0.0);
set(handles.radioBPSK,'Value',0.0);
set(handles.radioQPSK,'Value',1.0);
handles.changed=1;
% Update handles structure
guidata(hObject, handles);

function editSymDur_Callback(hObject, eventdata, handles)
% hObject    handle to editSymDur (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editSymDur as text
%        str2double(get(hObject,'String')) returns contents of editSymDur as a double
handles.changed=1;

if(  (1/str2double(get(handles.editSymDur,'String'))) > handles.B)
    msgbox('Symbol duration must correspond to bandwidth smaller than B, clipping');
    set(handles.editSymDur,'String',num2str(1/handles.B)); %%%%%% Notice I have no way of extracting particular default values 
end

% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editSymDur_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editSymDur (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editNumSym_Callback(hObject, eventdata, handles)
% hObject    handle to editNumSym (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editNumSym as text
%        str2double(get(hObject,'String')) returns contents of editNumSym as a double
handles.changed=1;
% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editNumSym_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editNumSym (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in radioSinc.
function radioSinc_Callback(hObject, eventdata, handles)
% hObject    handle to radioSinc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radioSinc 
set(handles.radioSinc,'Value',1.0);
set(handles.radioBPSK,'Value',0.0);
set(handles.radioQPSK,'Value',0.0);
handles.changed=1;
% Update handles structure
guidata(hObject, handles);


function editSigDur_Callback(hObject, eventdata, handles)
% hObject    handle to editSigDur (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editSigDur as text
%        str2double(get(hObject,'String')) returns contents of editSigDur as a double
handles.changed=1;
% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editSigDur_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editSigDur (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editSigDelay_Callback(hObject, eventdata, handles)
% hObject    handle to editSigDelay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editSigDelay as text
%        str2double(get(hObject,'String')) returns contents of editSigDelay as a double
handles.changed=1;
% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editSigDelay_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editSigDelay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editSigEnergy_Callback(hObject, eventdata, handles)
% hObject    handle to editSigEnergy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editSigEnergy as text
%        str2double(get(hObject,'String')) returns contents of editSigEnergy as a double
handles.changed=1;
% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editSigEnergy_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editSigEnergy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editShapeCosine_Callback(hObject, eventdata, handles)
% hObject    handle to editShapeCosine (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editShapeCosine as text
%        str2double(get(hObject,'String')) returns contents of editShapeCosine as a double
handles.changed=1;
% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editShapeCosine_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editShapeCosine (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on slider movement.
function slider1_Callback(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
set(handles.editShapeCosine,'String',num2str(get(handles.slider1,'Value')));
handles.changed=1;
% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function slider1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end



function editSymEnergy_Callback(hObject, eventdata, handles)
% hObject    handle to editSymEnergy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editSymEnergy as text
%        str2double(get(hObject,'String')) returns contents of editSymEnergy as a double
handles.changed=1;
% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editSymEnergy_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editSymEnergy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in radioSigEnergyRand.
function radioSigEnergyRand_Callback(hObject, eventdata, handles)
% hObject    handle to radioSigEnergyRand (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radioSigEnergyRand
set(handles.radioSigEnergyRand,'Value',1.0);
set(handles.radioSigEnergySpec,'Value',0.0);
set(handles.editSigEnergy,'Enable','off');
handles.changed=1;
% Update handles structure
guidata(hObject, handles);


% --- Executes on button press in radioSigEnergySpec.
function radioSigEnergySpec_Callback(hObject, eventdata, handles)
% hObject    handle to radioSigEnergySpec (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radioSigEnergySpec
set(handles.radioSigEnergyRand,'Value',0.0);
set(handles.radioSigEnergySpec,'Value',1.0);
set(handles.editSigEnergy,'Enable','on');
handles.changed=1;
% Update handles structure
guidata(hObject, handles);


% --- Executes on button press in radioSigDelayRand.
function radioSigDelayRand_Callback(hObject, eventdata, handles)
% hObject    handle to radioSigDelayRand (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radioSigDelayRand
set(handles.radioSigDelayRand,'Value',1.0);
set(handles.radioSigDelaySpec,'Value',0.0);
set(handles.editSigDelay,'Enable','off');
handles.changed=1;
% Update handles structure
guidata(hObject, handles);

% --- Executes on button press in radioSigDelaySpec.
function radioSigDelaySpec_Callback(hObject, eventdata, handles)
% hObject    handle to radioSigDelaySpec (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radioSigDelaySpec
set(handles.radioSigDelayRand,'Value',0.0);
set(handles.radioSigDelaySpec,'Value',1.0);
set(handles.editSigDelay,'Enable','on');
handles.changed=1;
% Update handles structure
guidata(hObject, handles);


% --- Executes on button press in radioSymEnergyRand.
function radioSymEnergyRand_Callback(hObject, eventdata, handles)
% hObject    handle to radioSymEnergyRand (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radioSymEnergyRand
set(handles.radioSymEnergyRand,'Value',1.0);
set(handles.radioSymEnergySpec,'Value',0.0);
set(handles.editSymEnergy,'Enable','off');
handles.changed=1;
% Update handles structure
guidata(hObject, handles);

% --- Executes on button press in radioSymEnergySpec.
function radioSymEnergySpec_Callback(hObject, eventdata, handles)
% hObject    handle to radioSymEnergySpec (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radioSymEnergySpec
set(handles.radioSymEnergyRand,'Value',0.0);
set(handles.radioSymEnergySpec,'Value',1.0);
set(handles.editSymEnergy,'Enable','on');
handles.changed=1;
% Update handles structure
guidata(hObject, handles);

% --- Executes on button press in radioSymShapeRand.
function radioSymShapeRand_Callback(hObject, eventdata, handles)
% hObject    handle to radioSymShapeRand (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radioSymShapeRand
set(handles.radioSymShapeRand,'Value',1.0);
set(handles.radioSymShapeCos,'Value',0.0);
set(handles.editShapeCosine,'Enable','off');
set(handles.slider1,'Enable','off');
handles.changed=1;
% Update handles structure
guidata(hObject, handles);

% --- Executes on button press in radioSymShapeCos.
function radioSymShapeCos_Callback(hObject, eventdata, handles)
% hObject    handle to radioSymShapeCos (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radioSymShapeCos
set(handles.radioSymShapeRand,'Value',0.0);
set(handles.radioSymShapeCos,'Value',1.0);
set(handles.editShapeCosine,'Enable','on');
set(handles.slider1,'Enable','on');
handles.changed=1;
% Update handles structure
guidata(hObject, handles);


% --- Executes on button press in radioCarrierRand.
function radioCarrierRand_Callback(hObject, eventdata, handles)
% hObject    handle to radioCarrierRand (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radioCarrierRand
set(handles.radioCarrierRand,'Value',1.0);
set(handles.radioCarrierSpec,'Value',0.0);
set(handles.editCarrier,'Enable','off');
handles.changed=1;
% Update handles structure
guidata(hObject, handles);

% --- Executes on button press in radioCarrierSpec.
function radioCarrierSpec_Callback(hObject, eventdata, handles)
% hObject    handle to radioCarrierSpec (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radioCarrierSpec
set(handles.radioCarrierRand,'Value',0.0);
set(handles.radioCarrierSpec,'Value',1.0);
set(handles.editCarrier,'Enable','on');
handles.changed=1;
% Update handles structure
guidata(hObject, handles);



function editCarrier_Callback(hObject, eventdata, handles)
% hObject    handle to editCarrier (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editCarrier as text
%        str2double(get(hObject,'String')) returns contents of editCarrier as a double
handles.changed=1;
% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editCarrier_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editCarrier (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function editSNR_Callback(hObject, eventdata, handles)
% hObject    handle to editSNR (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of editSNR as text
%        str2double(get(hObject,'String')) returns contents of editSNR as a double
handles.changed=1;
% Update handles structure
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function editSNR_CreateFcn(hObject, eventdata, handles)
% hObject    handle to editSNR (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on slider movement.
function slider2_Callback(hObject, eventdata, handles)
% hObject    handle to slider2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
set(handles.editSNR,'String',num2str(100*get(handles.slider2,'Value')));
handles.changed=1;
% Update handles structure
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function slider2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
errFlag1=0; errFlag2=0; errFlag3=0;  % OMRI: what are these error flags ?

% Signal Energy Check
if get(handles.radioSigEnergySpec,'Value')==1.0
    Semicolons=get(handles.editSigEnergy,'String');
    [Arr isNChanged errFlag1] = fromSemicolons2Arr(hObject, eventdata, handles, Semicolons);
    if ~errFlag1
        outputStruct.SincEnergiesString=get(handles.editSigEnergy,'String');
    end
    if isNChanged
        outputStruct.N=length(Arr)/2;
    else
        outputStruct.N=handles.N;
    end
end

% Signal Delay Check
if get(handles.radioSigDelaySpec,'Value')==1.0
    Semicolons=get(handles.editSigDelay,'String');
    [Arr isNChanged errFlag2] = fromSemicolons2Arr(hObject, eventdata, handles, Semicolons);
    if ~errFlag2
        outputStruct.SincDelayString=get(handles.editSigDelay,'String');
    end
    if isNChanged
        outputStruct.N=length(Arr)/2;
    else
        outputStruct.N=handles.N;
    end
end


% Carrier Check
if get(handles.radioCarrierSpec,'Value')==1.0
    Semicolons=get(handles.editCarrier,'String');
    Arr = 1e9*str2num(Semicolons);
    isNChanged=0;
    if  ~isempty(Arr) &  ~sum(Arr < handles.B |  Arr > (handles.fmax - handles.B)  )
        errFlag3=0;
    else
        errFlag3=1;
    end
    if length(Arr) ~=  handles.N/2 && errFlag3==0
        %     set(handles.editCarrier,'ForegroundColor','red');
        %     msgbox(['There must be ' num2str(handles.N/2) ' Values']);
        isNChanged=1;
    else
        set(handles.editCarrier,'ForegroundColor','black');
    end
    if errFlag3
        set(handles.editCarrier,'ForegroundColor','red');
        msgbox('Invalid Carrier input');
    end
    if ~errFlag3
        outputStruct.CarrierString=get(handles.editCarrier,'String');
    end
    if isNChanged
        outputStruct.N=length(Arr)/2;
    else
        outputStruct.N=handles.N;
    end
end

if get(handles.radioSinc,'Value')
    outputStruct.Type='sinc';   
    outputStruct.SincDuration=str2double(get(handles.editSigDur,'String'));
   
    if get(handles.radioSigEnergyRand,'Value')
        outputStruct.SincEnergies = 'random';
    elseif get(handles.radioSigEnergySpec,'Value')
        outputStruct.SincEnergies = 'specify';
        outputStruct.SincEnergiesString = get(handles.editSigEnergy,'String');
    end
    
    if get(handles.radioSigDelayRand,'Value')
        outputStruct.SincDelays = 'random';
    elseif get(handles.radioSigDelaySpec,'Value')
        outputStruct.SincDelays = 'specify';
        outputStruct.SincDelaysString = get(handles.editSigDelay,'String');
    end
    
    outputStruct.SincDuration=str2double(get(handles.editSigDur,'String'));
elseif get(handles.radioBPSK,'Value')
    outputStruct.Type='bpsk';
    outputStruct.BPSK_Tsymbol=str2double(get(handles.editSymDur,'String'));    
    outputStruct.BPSK_NumSymbols=str2double(get(handles.editNumSym,'String'));
   
    if get(handles.radioSymEnergyRand,'Value')
        outputStruct.BPSKEnergies = 'random';
    elseif get(handles.radioSymEnergySpec,'Value')
        outputStruct.BPSKEnergies = 'specify';
        outputStruct.BPSKEnergiesString = get(handles.editSymEnergy,'String');
    end
    
    if get(handles.radioSymShapeRand,'Value')
        outputStruct.BPSK_pulseshape = 'sinc';
    elseif get(handles.radioSymShapeCos,'Value')
        outputStruct.BPSK_pulseshape = 'raised-cosine';
        outputStruct.BPSK_pulseshape_rolloff = str2double(get(handles.editShapeCosine,'String'));
    end 
    
    
elseif get(handles.radioQPSK,'Value')
    outputStruct.Type='qpsk';
    outputStruct.QPSK_Tsymbol=str2double(get(handles.editSymDur,'String'));
    outputStruct.QPSK_NumSymbols=str2double(get(handles.editNumSym,'String'));
   
    if get(handles.radioSymEnergyRand,'Value')
        outputStruct.QPSKEnergies = 'random';
    elseif get(handles.radioSymEnergySpec,'Value')
        outputStruct.QPSKEnergies = 'specify';
        outputStruct.QPSKEnergiesString = get(handles.editSymEnergy,'String');
    end
    
    if get(handles.radioSymShapeRand,'Value')
        outputStruct.QPSK_pulseshape = 'sinc';
    elseif get(handles.radioSymShapeCos,'Value')
        outputStruct.QPSK_pulseshape = 'raised-cosine';
        outputStruct.QPSK_pulseshape_rolloff = str2double(get(handles.editShapeCosine,'String'));
    end 
end

if get(handles.radioCarrierRand,'Value')
    outputStruct.Carriers = 'random';
elseif get(handles.radioCarrierSpec,'Value')
    outputStruct.Carriers = 'specify';
    outputStruct.CarriersString = get(handles.editCarrier,'String');
end

outputStruct.SNR = str2num(get(handles.editSNR,'String'));



if ~errFlag1 && ~errFlag2 && ~errFlag3 
    handles.output=outputStruct;
    handles.output.N=handles.N;
    handles.output.B=handles.B;
    handles.output.fmax=handles.fmax;
    handles.output.changed=handles.changed;
    handles.OutputFlag = 1;
    % Update handles structure
    guidata(hObject, handles);
    uiresume(handles.figAdvanced);
end

% --- Executes on button press in pushbutton1.
function [Arr isNChanged errFlag] = fromSemicolons2Arr(hObject, eventdata, handles, Semicolons)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
Arr = str2num(Semicolons);
isNChanged=0;
if  ~isempty(Arr)
  errFlag=0;  
else
    errFlag=1;
end
if length(Arr) ~=  handles.N/2 && errFlag==0
    %     set(handles.editCarrier,'ForegroundColor','red');
    %     msgbox(['There must be ' num2str(handles.N/2) ' Values']);
    isNChanged=1;
else
    set(handles.editCarrier,'ForegroundColor','black');
end
if errFlag
    set(handles.editCarrier,'ForegroundColor','red');
    msgbox('Invalid input');
end
