/************************************************************************
*
*  File name: motif_ids.h
*
*  Description: Header file
*  
*  Copyright  2002-2004 Weizmann Institute of Science, 
*			   76100 Rehovot Israel, All rights reserved 
*
*************************************************************************/
#ifndef __MOTIF_IDS_H
#define __MOTIF_IDS_H

#include <stdio.h>
#include "list.h"
#include "mat.h"



/******************* Definitions ************************/



/******************* Structures *************************/

/******************* Prototypes *************************/
list64*
calc_mtf_id_iso(__int64 id, int mtf_sz);
list64*
get_mtf_subid(__int64 id, int mtf_sz);
void
fill_mat_id(Matrix *M, __int64 id);
__int64
get_mtf_subid_min_con_vrtx_less(__int64 id, int mtf_sz);
__int64
get_rep_mtf_id_3(__int64 mtf_id);
void
fill_mat_id(Matrix *M, __int64 id);
int
gen_subset_matrix(Network *N, Network **SN, list *vrtx_set, int mtf_sz);
int *
get_perm(int size,int index);

#endif